/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.S3ObjectTag;

final class S3ObjectTagListCopier {
    S3ObjectTagListCopier() {
    }

    static List<S3ObjectTag> copy(Collection<? extends S3ObjectTag> s3ObjectTagListParam) {
        Object list;
        if (s3ObjectTagListParam == null || s3ObjectTagListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(s3ObjectTagListParam.size());
            s3ObjectTagListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3ObjectTag> copyFromBuilder(Collection<? extends S3ObjectTag.Builder> s3ObjectTagListParam) {
        Object list;
        if (s3ObjectTagListParam == null || s3ObjectTagListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(s3ObjectTagListParam.size());
            s3ObjectTagListParam.forEach(entry -> {
                S3ObjectTag member = entry == null ? null : (S3ObjectTag)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3ObjectTag.Builder> copyToBuilder(Collection<? extends S3ObjectTag> s3ObjectTagListParam) {
        Object list;
        if (s3ObjectTagListParam == null || s3ObjectTagListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(s3ObjectTagListParam.size());
            s3ObjectTagListParam.forEach(entry -> {
                S3ObjectTag.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

