/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.google.common.collect.ImmutableSet;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.array.ArrayViewStrategy;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.ColumnFilter;
import com.jetbrains.python.debugger.containerview.PyDataViewerCommunityPanel;
import com.jetbrains.python.debugger.dataframe.DataFrameViewStrategy;
import com.jetbrains.python.debugger.dataframe.SeriesViewStrategy;
import java.util.Set;
import javax.swing.RowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataViewStrategy {
    public abstract AsyncArrayTableModel createTableModel(int var1, int var2, @NotNull PyDataViewerCommunityPanel var3, @NotNull PyDebugValue var4);

    public abstract ColoredCellRenderer createCellRenderer(double var1, double var3, @NotNull ArrayChunk var5);

    public abstract boolean isNumeric(String var1);

    @NotNull
    public abstract String sortModifier(@NotNull String var1, @NotNull RowSorter.SortKey var2);

    @NotNull
    public abstract String filterModifier(@NotNull String var1, @NotNull ColumnFilter var2);

    @Nullable
    public String getInitExecuteString() {
        return null;
    }

    @NotNull
    public abstract String getTypeName();

    public boolean showColumnHeader() {
        return true;
    }

    @Nullable
    public static DataViewStrategy getStrategy(String type2) {
        for (DataViewStrategy strategy : StrategyHolder.STRATEGIES) {
            if (!strategy.getTypeName().equals(type2)) continue;
            return strategy;
        }
        return null;
    }

    private static class StrategyHolder {
        private static final Set<DataViewStrategy> STRATEGIES = ImmutableSet.of((Object)ArrayViewStrategy.createInstanceForNumpyArray(), (Object)ArrayViewStrategy.createInstanceForNumpyRecarray(), (Object)ArrayViewStrategy.createInstanceForEagerTensor(), (Object)ArrayViewStrategy.createInstanceForResourceVariable(), (Object)ArrayViewStrategy.createInstanceForSparseTensor(), (Object)ArrayViewStrategy.createInstanceForTensor(), (Object[])new DataViewStrategy[]{DataFrameViewStrategy.createInstanceForDataFrame(), DataFrameViewStrategy.createInstanceForGeoDataFrame(), DataFrameViewStrategy.createInstanceForDataset(), SeriesViewStrategy.createInstanceForSeries(), SeriesViewStrategy.createInstanceForGeoSeries()});

        private StrategyHolder() {
        }
    }
}

