/// \file
/// \ingroup tutorial_legacy
/// This script is a representation using TTasks of the Geant3 simulation program
/// This example uses directly TTask objects.
/// A real implementation would require one class per task derived from TTask.
///
/// \macro_code
///
/// \author Rene Brun

void geant3tasks()
{
   TTask *geant3 = new TTask("geant3","Geant3 simulation main program");
   gROOT->GetListOfTasks()->Add(geant3);
   TTask *uginit = new TTask("uginit","Initialisation manager");
   TTask *grun   = new TTask("grun","Run manager");
   TTask *uglast = new TTask("uglast","Termination manager");
   geant3->Add(uginit);
   geant3->Add(grun);
   geant3->Add(uglast);
   TTask *ginit  = new TTask("ginit","Geant3 initialisation");
   TTask *ugeom  = new TTask("ugeom","Geometry initialisation manager");
   TTask *gphysi = new TTask("gphysi","Initialise cross-sections and energy loss tables");
   TTask *ggclos = new TTask("ggclos","Geometry analyzer and optimizer");
   uginit->Add(ginit);
   uginit->Add(ugeom);
   uginit->Add(gphysi);
   uginit->Add(ggclos);
   TTask *gtrigi = new TTask("gtrigi","Event initialisation");
   TTask *gtrig  = new TTask("gtrig","Event manager");
   TTask *gtrigc = new TTask("gtrigc","Event cleaner");
   grun->Add(gtrigi);
   grun->Add(gtrig);
   grun->Add(gtrigc);
   TTask *glast  = new TTask("glast","Geant3 termination");
   TTask *igend  = new TTask("igend","Graphics package termination");
   uglast->Add(glast);
   uglast->Add(igend);
   TTask *gukine = new TTask("gukine","Event generator manager");
   TTask *gutrev = new TTask("gutrev","Event application manager");
   TTask *gudigi = new TTask("gudigi","Event digitisation manager");
   TTask *guout  = new TTask("guout","Event termination manager");
   gtrig->Add(gukine);
   gtrig->Add(gutrev);
   gtrig->Add(gudigi);
   gtrig->Add(guout);
   TTask *gtreve = new TTask("gtreve","Geant3 event manager");
   gutrev->Add(gtreve);
   TTask *gltrac = new TTask("gltrac","Initialize tracking parameters");
   TTask *gftrac = new TTask("gftrac","select next track segment from stack JTRACK");
   TTask *gutrak = new TTask("gutrak","Application track manager");
   gtreve->Add(gltrac);
   gtreve->Add(gftrac);
   gtreve->Add(gutrak);
   TTask *gtrack = new TTask("gtrack","Geant3 track manager");
   gutrak->Add(gtrack);
   TTask *gtgama = new TTask("gtgama","photon propagator");
   TTask *gtelec = new TTask("gtelec","electron propagator");
   TTask *gtneut = new TTask("gtneut","neutron propagator");
   TTask *gthadr = new TTask("gthadr","hadron propagator");
   TTask *gtmuon = new TTask("gtmuon","muon propagator");
   TTask *gtnino = new TTask("gtnino","geantino propagator");
   TTask *gtckov = new TTask("gtckov","Cherenkov light propagator");
   TTask *gthion = new TTask("gthion","heavy ion propagator");
   TTask *gustep = new TTask("gustep","Application step manager");
   TTask *gtmedi = new TTask("gtmedi","Geometry volume finder");
   gtrack->Add(gtgama);
   gtrack->Add(gtelec);
   gtrack->Add(gtneut);
   gtrack->Add(gthadr);
   gtrack->Add(gtmuon);
   gtrack->Add(gtnino);
   gtrack->Add(gtckov);
   gtrack->Add(gthion);
   gtrack->Add(gustep);
   gtrack->Add(gtmedi);
   TTask *gtnext = new TTask("gtnext","Geometry bounary manager");
   TTask *gpairg = new TTask("gpairg","Generate pair production");
   TTask *gcomp  = new TTask("gcomp","Generate Compton scattering");
   TTask *gphot  = new TTask("gphot","Generate photo effect");
   TTask *grayl  = new TTask("grayl","Generate Rayleigh effect");
   TTask *gpfis  = new TTask("gpfis","Generate photo fission");
   gtgama->Add(gtnext);
   gtgama->Add(gpairg);
   gtgama->Add(gcomp);
   gtgama->Add(gphot);
   gtgama->Add(grayl);
   gtgama->Add(gpfis);
   TTask *guswim = new TTask("guswim","magnetic field propagator");
   TTask *ggckov = new TTask("ggckov","Generate Cherenkov photons");
   TTask *gsync  = new TTask("gsync","Generate synchrotron radiation");
   TTask *gmults = new TTask("gmults","Apply multiple scattering");
   TTask *gbreme = new TTask("gbreme","Generate Bremsstrahlung");
   TTask *gdray  = new TTask("gdray","Generate delta ray");
   TTask *ganni  = new TTask("ganni","Generate Positron annihilation");
   TTask *gannir = new TTask("gannir","Stopped tracks and annihilation at rest");
   gtelec->Add(gtnext);
   gtelec->Add(guswim);
   gtelec->Add(ggckov);
   gtelec->Add(gsync);
   gtelec->Add(gmults);
   gtelec->Add(gbreme);
   gtelec->Add(gdray);
   gtelec->Add(ganni);
   gtelec->Add(gannir);
   TTask *guphad = new TTask("guphad","Hadronic cross-section manager");
   TTask *guhadr = new TTask("guhadr","Hadronic cascade manager");
   TTask *gdecay = new TTask("gdecay","Particle decay");
   gtneut->Add(gtnext);
   gtneut->Add(guphad);
   gtneut->Add(guhadr);
   gtneut->Add(gdecay);

   gthadr->Add(gtnext);
   gthadr->Add(guphad);
   gthadr->Add(guswim);
   gthadr->Add(ggckov);
   gthadr->Add(gmults);
   gthadr->Add(guhadr);
   gthadr->Add(gdecay);
   gthadr->Add(gdray);
   TTask *gbremm = new TTask("gbremm","Generate Bremsstrahlung");
   TTask *gpairm = new TTask("gpairm","Generate Pair production");
   TTask *gmunu  = new TTask("gmunu","Generate Nuclear interaction");
   gtmuon->Add(gtnext);
   gtmuon->Add(guswim);
   gtmuon->Add(ggckov);
   gtmuon->Add(gmults);
   gtmuon->Add(gbremm);
   gtmuon->Add(gpairm);
   gtmuon->Add(gdecay);
   gtmuon->Add(gdray);
   gtmuon->Add(gmunu);
   gtmuon->Add(gdecay);

   gtnino->Add(gtnext);
   TTask *glisur = new TTask("glisur","Photon is reflected");
   gtckov->Add(gtnext);
   gtckov->Add(glisur);

   gthion->Add(gtnext);
   gthion->Add(guswim);
   gthion->Add(gmults);
   gthion->Add(guhadr);
   gthion->Add(gdray);

   new TBrowser;
   gDebug = 2;
}
