﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/migrationhuborchestrator/MigrationHubOrchestrator_EXPORTS.h>
#include <aws/migrationhuborchestrator/model/StepActionType.h>
#include <aws/migrationhuborchestrator/model/StepAutomationConfiguration.h>
#include <aws/migrationhuborchestrator/model/StepOutput.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MigrationHubOrchestrator {
namespace Model {
class GetTemplateStepResult {
 public:
  AWS_MIGRATIONHUBORCHESTRATOR_API GetTemplateStepResult() = default;
  AWS_MIGRATIONHUBORCHESTRATOR_API GetTemplateStepResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MIGRATIONHUBORCHESTRATOR_API GetTemplateStepResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of the step.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  GetTemplateStepResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the step group.</p>
   */
  inline const Aws::String& GetStepGroupId() const { return m_stepGroupId; }
  template <typename StepGroupIdT = Aws::String>
  void SetStepGroupId(StepGroupIdT&& value) {
    m_stepGroupIdHasBeenSet = true;
    m_stepGroupId = std::forward<StepGroupIdT>(value);
  }
  template <typename StepGroupIdT = Aws::String>
  GetTemplateStepResult& WithStepGroupId(StepGroupIdT&& value) {
    SetStepGroupId(std::forward<StepGroupIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the template.</p>
   */
  inline const Aws::String& GetTemplateId() const { return m_templateId; }
  template <typename TemplateIdT = Aws::String>
  void SetTemplateId(TemplateIdT&& value) {
    m_templateIdHasBeenSet = true;
    m_templateId = std::forward<TemplateIdT>(value);
  }
  template <typename TemplateIdT = Aws::String>
  GetTemplateStepResult& WithTemplateId(TemplateIdT&& value) {
    SetTemplateId(std::forward<TemplateIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the step.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetTemplateStepResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the step.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  GetTemplateStepResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The action type of the step. You must run and update the status of a manual
   * step for the workflow to continue after the completion of the step.</p>
   */
  inline StepActionType GetStepActionType() const { return m_stepActionType; }
  inline void SetStepActionType(StepActionType value) {
    m_stepActionTypeHasBeenSet = true;
    m_stepActionType = value;
  }
  inline GetTemplateStepResult& WithStepActionType(StepActionType value) {
    SetStepActionType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time at which the step was created.</p>
   */
  inline const Aws::String& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::String>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::String>
  GetTemplateStepResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The previous step.</p>
   */
  inline const Aws::Vector<Aws::String>& GetPrevious() const { return m_previous; }
  template <typename PreviousT = Aws::Vector<Aws::String>>
  void SetPrevious(PreviousT&& value) {
    m_previousHasBeenSet = true;
    m_previous = std::forward<PreviousT>(value);
  }
  template <typename PreviousT = Aws::Vector<Aws::String>>
  GetTemplateStepResult& WithPrevious(PreviousT&& value) {
    SetPrevious(std::forward<PreviousT>(value));
    return *this;
  }
  template <typename PreviousT = Aws::String>
  GetTemplateStepResult& AddPrevious(PreviousT&& value) {
    m_previousHasBeenSet = true;
    m_previous.emplace_back(std::forward<PreviousT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The next step.</p>
   */
  inline const Aws::Vector<Aws::String>& GetNext() const { return m_next; }
  template <typename NextT = Aws::Vector<Aws::String>>
  void SetNext(NextT&& value) {
    m_nextHasBeenSet = true;
    m_next = std::forward<NextT>(value);
  }
  template <typename NextT = Aws::Vector<Aws::String>>
  GetTemplateStepResult& WithNext(NextT&& value) {
    SetNext(std::forward<NextT>(value));
    return *this;
  }
  template <typename NextT = Aws::String>
  GetTemplateStepResult& AddNext(NextT&& value) {
    m_nextHasBeenSet = true;
    m_next.emplace_back(std::forward<NextT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The outputs of the step.</p>
   */
  inline const Aws::Vector<StepOutput>& GetOutputs() const { return m_outputs; }
  template <typename OutputsT = Aws::Vector<StepOutput>>
  void SetOutputs(OutputsT&& value) {
    m_outputsHasBeenSet = true;
    m_outputs = std::forward<OutputsT>(value);
  }
  template <typename OutputsT = Aws::Vector<StepOutput>>
  GetTemplateStepResult& WithOutputs(OutputsT&& value) {
    SetOutputs(std::forward<OutputsT>(value));
    return *this;
  }
  template <typename OutputsT = StepOutput>
  GetTemplateStepResult& AddOutputs(OutputsT&& value) {
    m_outputsHasBeenSet = true;
    m_outputs.emplace_back(std::forward<OutputsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The custom script to run tests on source or target environments.</p>
   */
  inline const StepAutomationConfiguration& GetStepAutomationConfiguration() const { return m_stepAutomationConfiguration; }
  template <typename StepAutomationConfigurationT = StepAutomationConfiguration>
  void SetStepAutomationConfiguration(StepAutomationConfigurationT&& value) {
    m_stepAutomationConfigurationHasBeenSet = true;
    m_stepAutomationConfiguration = std::forward<StepAutomationConfigurationT>(value);
  }
  template <typename StepAutomationConfigurationT = StepAutomationConfiguration>
  GetTemplateStepResult& WithStepAutomationConfiguration(StepAutomationConfigurationT&& value) {
    SetStepAutomationConfiguration(std::forward<StepAutomationConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetTemplateStepResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_stepGroupId;
  bool m_stepGroupIdHasBeenSet = false;

  Aws::String m_templateId;
  bool m_templateIdHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  StepActionType m_stepActionType{StepActionType::NOT_SET};
  bool m_stepActionTypeHasBeenSet = false;

  Aws::String m_creationTime;
  bool m_creationTimeHasBeenSet = false;

  Aws::Vector<Aws::String> m_previous;
  bool m_previousHasBeenSet = false;

  Aws::Vector<Aws::String> m_next;
  bool m_nextHasBeenSet = false;

  Aws::Vector<StepOutput> m_outputs;
  bool m_outputsHasBeenSet = false;

  StepAutomationConfiguration m_stepAutomationConfiguration;
  bool m_stepAutomationConfigurationHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MigrationHubOrchestrator
}  // namespace Aws
