﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pca-connector-scep/PcaConnectorScep_EXPORTS.h>
#include <aws/pca-connector-scep/model/Connector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace PcaConnectorScep {
namespace Model {
class GetConnectorResult {
 public:
  AWS_PCACONNECTORSCEP_API GetConnectorResult() = default;
  AWS_PCACONNECTORSCEP_API GetConnectorResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PCACONNECTORSCEP_API GetConnectorResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The properties of the connector.</p>
   */
  inline const Connector& GetConnector() const { return m_connector; }
  template <typename ConnectorT = Connector>
  void SetConnector(ConnectorT&& value) {
    m_connectorHasBeenSet = true;
    m_connector = std::forward<ConnectorT>(value);
  }
  template <typename ConnectorT = Connector>
  GetConnectorResult& WithConnector(ConnectorT&& value) {
    SetConnector(std::forward<ConnectorT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetConnectorResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Connector m_connector;
  bool m_connectorHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PcaConnectorScep
}  // namespace Aws
