﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>
#include <aws/workspaces/model/FailedWorkspaceChangeRequest.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkSpaces {
namespace Model {
class StopWorkspacesResult {
 public:
  AWS_WORKSPACES_API StopWorkspacesResult() = default;
  AWS_WORKSPACES_API StopWorkspacesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACES_API StopWorkspacesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Information about the WorkSpaces that could not be stopped.</p>
   */
  inline const Aws::Vector<FailedWorkspaceChangeRequest>& GetFailedRequests() const { return m_failedRequests; }
  template <typename FailedRequestsT = Aws::Vector<FailedWorkspaceChangeRequest>>
  void SetFailedRequests(FailedRequestsT&& value) {
    m_failedRequestsHasBeenSet = true;
    m_failedRequests = std::forward<FailedRequestsT>(value);
  }
  template <typename FailedRequestsT = Aws::Vector<FailedWorkspaceChangeRequest>>
  StopWorkspacesResult& WithFailedRequests(FailedRequestsT&& value) {
    SetFailedRequests(std::forward<FailedRequestsT>(value));
    return *this;
  }
  template <typename FailedRequestsT = FailedWorkspaceChangeRequest>
  StopWorkspacesResult& AddFailedRequests(FailedRequestsT&& value) {
    m_failedRequestsHasBeenSet = true;
    m_failedRequests.emplace_back(std::forward<FailedRequestsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StopWorkspacesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<FailedWorkspaceChangeRequest> m_failedRequests;
  bool m_failedRequestsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
