/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeIterator;
import java.util.NoSuchElementException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class NodeIteratorImpl
implements NodeIterator,
org.w3c.dom.traversal.NodeIterator {
    private final AbstractDOMNode rootNode;
    private AbstractDOMNode currentNode;
    private AbstractDOMNode last = null;
    private int currentIndex = 0;
    private final int whatToShow;
    private final NodeFilter nodeFilter;

    NodeIteratorImpl(AbstractDOMNode rootNode, int whatToShow, NodeFilter filter) {
        this.rootNode = rootNode;
        this.nodeFilter = filter;
        this.whatToShow = whatToShow;
        this.currentNode = null;
    }

    @Override
    public AbstractDOMNode getRoot() {
        return this.rootNode;
    }

    @Override
    public int getWhatToShow() {
        return this.whatToShow;
    }

    @Override
    public NodeFilter getNodeFilter() {
        return this.nodeFilter;
    }

    @Override
    public boolean hasNext() {
        AbstractDOMNode next = this.findNext();
        return next != this.rootNode || this.currentNode == null && (this.isAccepted(next) || this.findNext(next) != this.rootNode);
    }

    private AbstractDOMNode findNext() {
        if (this.currentNode == null) {
            return this.rootNode;
        }
        return this.findNext(this.currentNode);
    }

    private AbstractDOMNode findNext(AbstractDOMNode current) {
        short filter;
        AbstractDOMNode next = this.nextNode(current);
        while (next != this.rootNode && (filter = this.filter(next)) != 1) {
            if (filter != 3) {
                next = this.nextSiblingOrParent(next);
                continue;
            }
            next = this.nextNode(next);
        }
        return next;
    }

    private AbstractDOMNode nextNode(AbstractDOMNode current) {
        AbstractDOMNode next = current.getNodeList().getFirst();
        if (next == null) {
            next = current != this.rootNode || this.rootNode.getNodeType() == 2 ? this.nextSiblingOrParent(current) : current;
        }
        return next;
    }

    private AbstractDOMNode nextSiblingOrParent(AbstractDOMNode current) {
        AbstractDOMNode next = current.nextSibling;
        if (next == null) {
            AbstractDOMNode parent = current.parentNode();
            if (parent != this.rootNode && parent != null) {
                return this.nextSiblingOrParent(parent);
            }
            next = this.rootNode;
        }
        return next;
    }

    private boolean isToShow(Node node) {
        int maskBit = NodeFilter.maskTable[node.getNodeType() - 1];
        return (this.whatToShow & maskBit) == maskBit;
    }

    private short filter(Node node) {
        if (!this.isToShow(node)) {
            return 3;
        }
        return this.nodeFilter == null ? (short)1 : this.nodeFilter.acceptNode(node);
    }

    @Override
    public DOMNode next() {
        AbstractDOMNode next = this.findNext();
        if (next != this.rootNode || this.currentNode == null && (this.isAccepted(next) || (next = this.findNext(next)) != this.rootNode)) {
            ++this.currentIndex;
            this.last = next;
            this.currentNode = next;
            return next;
        }
        throw new NoSuchElementException();
    }

    private boolean isAccepted(AbstractDOMNode node) {
        return this.filter(node) == 1;
    }

    @Override
    public DOMNode nextNode() {
        try {
            return this.next();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public boolean hasPrevious() {
        return this.currentNode != null;
    }

    private AbstractDOMNode findPrevious() {
        AbstractDOMNode previous;
        if (this.currentNode != this.rootNode) {
            short filter;
            previous = this.previousNode(this.currentNode);
            while (previous != this.rootNode && (filter = this.filter(previous)) != 1) {
                previous = this.previousNode(previous);
            }
        } else {
            previous = null;
        }
        return previous;
    }

    private AbstractDOMNode previousNode(AbstractDOMNode current) {
        AbstractDOMNode previous = current.previousSibling;
        if (previous == null) {
            previous = current.parentNode();
        } else {
            while (true) {
                AbstractDOMNode prev;
                short filter;
                if ((filter = this.filter(previous)) != 2) {
                    prev = previous.getNodeList().getLast();
                    if (prev == null) break;
                    previous = prev;
                    continue;
                }
                prev = previous.previousSibling;
                if (prev == null) break;
                previous = prev;
            }
        }
        return previous;
    }

    @Override
    public DOMNode previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentIndex;
        this.last = this.currentNode;
        AbstractDOMNode prev = this.findPrevious();
        this.currentNode = prev != this.rootNode || this.isAccepted(prev) ? prev : null;
        return this.last;
    }

    @Override
    public DOMNode previousNode() {
        try {
            return this.previous();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public int nextIndex() {
        return this.currentIndex;
    }

    @Override
    public int previousIndex() {
        return this.currentIndex - 1;
    }

    @Override
    public void remove() {
        if (this.last != null && this.last != this.rootNode) {
            AbstractDOMNode parent = this.last.parentNode();
            if (parent == null) {
                throw new IllegalStateException("Node to remove has no parent.");
            }
            if (this.currentNode != this.rootNode) {
                if (this.currentNode != this.last) {
                    if (this.last != this.findNext()) {
                        throw new IllegalStateException();
                    }
                } else {
                    this.currentNode = this.previousNode(this.last);
                    --this.currentIndex;
                }
            } else if (this.last != this.findNext()) {
                throw new IllegalStateException();
            }
            if (this.last.getNodeType() != 2) {
                parent.removeChild(this.last);
            } else {
                parent.getAttributes().removeNamedItemNS(this.last.getNamespaceURI(), this.last.getLocalName());
            }
        } else {
            throw new IllegalStateException();
        }
        this.last = null;
    }

    @Override
    public void set(Node node) {
        AbstractDOMNode parent;
        if (this.last != null && this.last != this.rootNode && (parent = this.last.parentNode()) != null) {
            AbstractDOMNode newNode = (AbstractDOMNode)node;
            if (this.last.getNodeType() != 2) {
                parent.replaceChild(node, this.last);
                if (!this.isAccepted(newNode)) {
                    parent.replaceChild(this.last, newNode);
                    throw new IllegalArgumentException("Not part of the logical tree.");
                }
            } else {
                if (node.getNodeType() != 2) {
                    throw new DOMException(3, "Not an attribute.");
                }
                DOMElement.MyNamedNodeMap nnm = ((DOMElement)parent).nodeMap;
                nnm.replaceItem((DOMAttr)node, (DOMAttr)this.last);
                if (!this.isAccepted(newNode)) {
                    nnm.replaceItem((DOMAttr)this.last, (DOMAttr)node);
                    throw new IllegalArgumentException("Not part of the logical tree.");
                }
            }
            if (this.currentNode == this.last) {
                this.currentNode = newNode;
            }
        } else {
            throw new IllegalStateException();
        }
        this.last = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(Node node) {
        AbstractDOMNode newNode = (AbstractDOMNode)node;
        if (this.currentNode == null) {
            throw new IllegalStateException();
        }
        short type = this.currentNode.getNodeType();
        if (type != 1 && type != 9) {
            AbstractDOMNode parent = this.currentNode.parentNode();
            if (parent == null) throw new IllegalStateException("Collection was modified outside of this iterator.");
            if (this.currentNode.getNodeType() != 2) {
                parent.insertAfter(newNode, this.currentNode);
            } else {
                if (node.getNodeType() != 2) {
                    throw new DOMException(3, "Not an attribute.");
                }
                ((DOMElement)parent).nodeMap.insertAfter((DOMAttr)newNode, this.currentNode);
            }
        } else {
            this.currentNode.insertBefore(newNode, this.currentNode.getNodeList().getFirst());
        }
        this.currentNode = newNode;
        if (!this.isAccepted(newNode)) {
            this.currentNode = this.findPrevious();
        } else {
            ++this.currentIndex;
        }
        this.last = null;
    }

    @Override
    public org.w3c.dom.traversal.NodeFilter getFilter() {
        if (this.nodeFilter instanceof org.w3c.dom.traversal.NodeFilter) {
            return (org.w3c.dom.traversal.NodeFilter)((Object)this.nodeFilter);
        }
        return null;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return false;
    }

    @Override
    public void detach() {
    }
}

