/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMPolicyException;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSImportRule;

public class ImportRule
extends BaseCSSRule
implements CSSImportRule,
CSSRule {
    private static final long serialVersionUID = 1L;
    private AbstractCSSStyleSheet importedSheet = null;
    private String styleSheetURI;
    private MediaQueryList mediaList;

    protected ImportRule(AbstractCSSStyleSheet parentSheet, MediaQueryList mediaList, String href, byte origin) {
        super(parentSheet, (short)3, origin);
        this.mediaList = mediaList;
        this.styleSheetURI = href;
    }

    @Override
    public String getHref() {
        return this.styleSheetURI;
    }

    @Override
    public MediaQueryList getMedia() {
        return this.mediaList;
    }

    @Override
    public AbstractCSSStyleSheet getStyleSheet() {
        if (this.importedSheet == null) {
            AbstractCSSStyleSheet parent = this.getParentStyleSheet();
            this.importedSheet = parent.getStyleSheetFactory().createRuleStyleSheet(this, parent.getTitle(), this.mediaList);
            this.importedSheet.setParentStyleSheet(parent);
            try {
                this.loadStyleSheet();
            }
            catch (DOMPolicyException e) {
                this.importedSheet = null;
            }
            catch (DOMException e) {
                parent.getErrorHandler().badAtRule(e, this.getCssText());
            }
            catch (IOException e) {
                parent.getDocumentErrorHandler().ioError(this.styleSheetURI, e);
            }
        }
        return this.importedSheet;
    }

    private boolean loadStyleSheet() throws IOException, DOMException {
        URL styleSheetURL = this.getURL(this.getHref());
        Node owner = this.getParentStyleSheet().getOwnerNode();
        CSSDocument cssdoc = owner != null ? (owner.getNodeType() == 9 ? (CSSDocument)owner : (CSSDocument)owner.getOwnerDocument()) : null;
        if (cssdoc != null && !cssdoc.isAuthorizedOrigin(styleSheetURL)) {
            cssdoc.getErrorHandler().policyError(owner, "Unauthorized @import URL: " + styleSheetURL.toExternalForm());
            return false;
        }
        return this.importedSheet.loadStyleSheet(styleSheetURL, "");
    }

    @Override
    void clear() {
    }

    @Override
    void setRule(AbstractCSSRule copyMe) {
        ImportRule imp = (ImportRule)copyMe;
        this.styleSheetURI = imp.getHref();
        this.mediaList = imp.getMedia();
        this.setPrecedingComments(imp.getPrecedingComments());
        this.setTrailingComments(imp.getTrailingComments());
        this.importedSheet = null;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(230);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        wri.write((CharSequence)"@import ");
        context.writeURL(wri, this.getHref());
        if (!this.mediaList.isAllMedia()) {
            wri.write(' ');
            wri.write((CharSequence)this.mediaList.getMedia());
        }
        context.writeSemiColon(wri);
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder buf = new StringBuilder(80);
        buf.append("@import ");
        buf.append(ParseHelper.quote(this.styleSheetURI, '\''));
        if (!this.mediaList.isAllMedia()) {
            buf.append(' ');
            buf.append(this.mediaList.getMinifiedMedia());
        }
        buf.append(';');
        return buf.toString();
    }

    @Override
    boolean hasErrorsOrWarnings() {
        return this.mediaList != null && this.mediaList.hasErrors();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mediaList == null ? 0 : this.mediaList.hashCode());
        result = 31 * result + (this.styleSheetURI == null ? 0 : this.styleSheetURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportRule other = (ImportRule)obj;
        if (this.mediaList == null ? other.mediaList != null : !this.mediaList.equals(other.mediaList)) {
            return false;
        }
        return !(this.styleSheetURI == null ? other.styleSheetURI != null : !this.styleSheetURI.equals(other.styleSheetURI));
    }

    @Override
    public ImportRule clone(AbstractCSSStyleSheet parentSheet) {
        ImportRule rule = new ImportRule(parentSheet, ((MediaListAccess)((Object)this.getMedia())).unmodifiable(), this.getHref(), this.getOrigin());
        return rule;
    }
}

