/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSResourceLimitException;
import io.sf.carte.doc.style.css.CSSSupportsRule;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.DeclarationCondition;
import io.sf.carte.doc.style.css.nsac.SelectorFunction;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.DOMException;

public class SupportsRule
extends GroupingRule
implements CSSSupportsRule {
    private static final long serialVersionUID = 1L;
    private BooleanCondition condition = null;

    protected SupportsRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)12, origin);
    }

    SupportsRule(AbstractCSSStyleSheet parentSheet, SupportsRule copyfrom) {
        super(parentSheet, copyfrom);
        this.condition = copyfrom.getCondition();
    }

    protected SupportsRule(AbstractCSSStyleSheet parentSheet, BooleanCondition condition, byte origin) {
        super(parentSheet, (short)12, origin);
        if (condition == null) {
            throw new NullPointerException("Null @supports condition.");
        }
        this.condition = condition;
    }

    @Override
    public String getConditionText() {
        return this.condition != null ? this.condition.toString() : "";
    }

    @Override
    public void setConditionText(String conditionText) throws DOMException {
        this.parseConditionText(conditionText);
    }

    private void parseConditionText(String conditionText) throws DOMException {
        CSSParser parser = (CSSParser)this.createSACParser();
        try {
            this.condition = parser.parseSupportsCondition(conditionText, null, this.getParentStyleSheet());
        }
        catch (CSSBudgetException e) {
            throw new CSSResourceLimitException("Limit found while parsing condition " + conditionText, e);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, "Error parsing condition: " + conditionText);
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public BooleanCondition getCondition() {
        return this.condition;
    }

    @Override
    public boolean supports(StyleDatabase styleDatabase) {
        return this.condition != null && this.supports(this.condition, styleDatabase);
    }

    private boolean supports(BooleanCondition condition, StyleDatabase styleDatabase) {
        switch (condition.getType()) {
            case PREDICATE: {
                DeclarationCondition declCond = (DeclarationCondition)condition;
                return styleDatabase.supports(declCond.getName(), declCond.getValue());
            }
            case AND: {
                List<BooleanCondition> subcond = condition.getSubConditions();
                if (subcond == null) {
                    AbstractCSSStyleSheet sheet = this.getParentStyleSheet();
                    if (sheet != null) {
                        sheet.getErrorHandler().conditionalRuleError(this.condition, "No conditions inside and(): " + this.condition.toString());
                    }
                    return false;
                }
                Iterator<BooleanCondition> it = subcond.iterator();
                while (it.hasNext()) {
                    if (this.supports(it.next(), styleDatabase)) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                BooleanCondition nested = condition.getNestedCondition();
                if (nested == null) {
                    AbstractCSSStyleSheet sheet = this.getParentStyleSheet();
                    if (sheet != null) {
                        sheet.getErrorHandler().conditionalRuleError(this.condition, "No conditions inside not(): " + this.condition.toString());
                    }
                    return false;
                }
                return !this.supports(nested, styleDatabase);
            }
            case OR: {
                List<BooleanCondition> subcond = condition.getSubConditions();
                if (subcond == null) {
                    AbstractCSSStyleSheet sheet = this.getParentStyleSheet();
                    if (sheet != null) {
                        sheet.getErrorHandler().conditionalRuleError(this.condition, "No conditions inside or(): " + this.condition.toString());
                    }
                    return false;
                }
                Iterator<BooleanCondition> it = subcond.iterator();
                while (it.hasNext()) {
                    if (!this.supports(it.next(), styleDatabase)) continue;
                    return true;
                }
                break;
            }
            case SELECTOR_FUNCTION: {
                SelectorFunction selCond = (SelectorFunction)condition;
                return styleDatabase.supports(selCond.getSelectors());
            }
        }
        return false;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getCssRules().getLength() * 32);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.condition != null || !this.getCssRules().isEmpty()) {
            StringBuilder sb = new StringBuilder(30 + this.getCssRules().getLength() * 20);
            sb.append("@supports");
            if (this.condition != null) {
                this.condition.appendMinifiedText(sb);
            }
            sb.append('{');
            Iterator it = this.getCssRules().iterator();
            while (it.hasNext()) {
                sb.append(((AbstractCSSRule)it.next()).getMinifiedCssText());
            }
            sb.append('}');
            return sb.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.condition != null || !this.getCssRules().isEmpty()) {
            context.startRule(wri, this.getPrecedingComments());
            wri.write((CharSequence)"@supports ");
            wri.write((CharSequence)this.getConditionText());
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            this.getCssRules().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endRuleList(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri, this.getTrailingComments());
        }
    }

    @Override
    protected void setGroupingRule(GroupingRule rule) throws DOMException {
        SupportsRule supportsRule = (SupportsRule)rule;
        this.condition = supportsRule.condition;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupportsRule other = (SupportsRule)obj;
        return !(this.condition == null ? other.condition != null : !this.condition.equals(other.condition));
    }

    @Override
    public SupportsRule clone(AbstractCSSStyleSheet parentSheet) {
        return new SupportsRule(parentSheet, this);
    }
}

