/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.Dimension;
import io.sf.carte.doc.style.css.parser.DimensionalAnalyzer;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MathFunctionUnitImpl;
import org.w3c.dom.DOMException;

class PowFunctionUnitImpl
extends MathFunctionUnitImpl {
    private static final long serialVersionUID = 1L;

    public PowFunctionUnitImpl(int functionIndex) {
        super(functionIndex);
    }

    @Override
    public Dimension dimension(DimensionalAnalyzer analyzer) throws DOMException {
        if (this.parameters == null) {
            throw new DOMException(12, "Missing argument in pow() function.");
        }
        Dimension dim = analyzer.expressionDimension(this.parameters.shallowClone());
        if (dim != null && dim.category != CSSValueSyntax.Category.number) {
            LexicalUnitImpl comma = this.parameters.nextLexicalUnit;
            if (comma == null || comma.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                throw new DOMException(12, "Expected comma in pow() function.");
            }
            LexicalUnitImpl expUnit = comma.nextLexicalUnit;
            if (expUnit == null) {
                throw new DOMException(12, "Missing argument in pow() function.");
            }
            if (expUnit.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
                dim.exponent *= expUnit.getIntegerValue();
            } else if (expUnit.getLexicalUnitType() == LexicalUnit.LexicalType.REAL) {
                dim.exponent = Math.round((float)dim.exponent * expUnit.getFloatValue());
            }
        }
        return dim;
    }

    @Override
    PowFunctionUnitImpl instantiateLexicalUnit() {
        return new PowFunctionUnitImpl(this.getMathFunctionIndex());
    }
}

