/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSEngineUserAgent;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueFactory;
import io.sf.carte.echosvg.css.engine.value.CSSProxyValueException;
import io.sf.carte.echosvg.css.engine.value.CalcValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LexicalValue;
import io.sf.carte.echosvg.css.engine.value.MathFunctionValue;
import io.sf.carte.echosvg.css.engine.value.Messages;
import io.sf.carte.echosvg.css.engine.value.NumericDelegateValue;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public abstract class AbstractValueManager
extends AbstractValueFactory
implements ValueManager {
    @Override
    public Value createFloatValue(short unitType, float floatValue) throws DOMException {
        throw this.createDOMException();
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String value, CSSEngine engine) throws DOMException {
        throw this.createDOMException();
    }

    protected Value createLexicalValue(LexicalUnit lu) throws CSSProxyValueException {
        if (lu.getPreviousLexicalUnit() != null || lu.isParameter()) {
            throw new CSSProxyValueException();
        }
        return new LexicalValue(lu);
    }

    protected Value createCalc(LexicalUnit lu) throws DOMException {
        ValueFactory vf = new ValueFactory();
        LexicalUnit lunit = lu.getNextLexicalUnit() != null ? lu.shallowClone() : lu;
        StyleValue cssValue = vf.createCSSValue(lunit);
        CSSValue.Type pType = cssValue.getPrimitiveType();
        if (pType != CSSValue.Type.EXPRESSION) {
            if (pType == CSSValue.Type.LEXICAL) {
                if (lunit.getPreviousLexicalUnit() != null || lunit.isParameter()) {
                    throw new CSSProxyValueException();
                }
                return this.createLexicalValue(lunit);
            }
            this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        }
        CalcValue calc = new CalcValue((CSSExpressionValue)cssValue){
            private static final long serialVersionUID = 1L;

            @Override
            protected FloatValue absoluteValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, FloatValue relative) {
                return (FloatValue)AbstractValueManager.this.computeValue(elt, pseudo, engine, idx, sm, relative);
            }
        };
        return calc;
    }

    protected Value createMathFunction(LexicalUnit lu, String syntax) throws DOMException {
        CSSValueSyntax syn;
        MathFunctionValue calc;
        ValueFactory vf = new ValueFactory();
        LexicalUnit lunit = lu.getNextLexicalUnit() != null ? lu.shallowClone() : lu;
        StyleValue cssValue = vf.createCSSValue(lunit);
        CSSValue.Type pType = cssValue.getPrimitiveType();
        if (pType != CSSValue.Type.MATH_FUNCTION) {
            if (pType == CSSValue.Type.LEXICAL) {
                if (lunit.getPreviousLexicalUnit() != null || lunit.isParameter()) {
                    throw new CSSProxyValueException();
                }
                return this.createLexicalValue(lunit);
            }
            this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        }
        if ((calc = new MathFunctionValue((CSSMathFunctionValue)cssValue){
            private static final long serialVersionUID = 1L;

            @Override
            protected FloatValue absoluteValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, FloatValue relative) {
                return (FloatValue)AbstractValueManager.this.computeValue(elt, pseudo, engine, idx, sm, relative);
            }
        }).matches(syn = new SyntaxParser().parseSyntax(syntax)) == CSSValueSyntax.Match.FALSE) {
            throw this.createDOMException(calc);
        }
        return calc;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value.getPrimitiveType() == CSSValue.Type.URI) {
            if (sm.isAttrTainted(idx)) {
                CSSEngineUserAgent ua = engine.getCSSEngineUserAgent();
                if (ua != null) {
                    ua.displayMessage("attr()-tainted value: " + value.getCssText());
                }
                return null;
            }
            String uri = value.getURIValue();
            return new URIValue(uri, uri);
        }
        return value;
    }

    protected Value evaluateMath(NumericDelegateValue<?> value, CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, short destUnit) throws DOMException {
        return value.evaluate(elt, pseudo, engine, idx, sm, destUnit);
    }

    protected float lengthValue(Value cv) {
        short unit = cv.getUnitType();
        if (!CSSUnit.isLengthUnitType((short)unit) && unit != 0) {
            throw this.createDOMException(cv);
        }
        return cv.getFloatValue();
    }

    protected DOMException createDOMException(Value cv) {
        Object[] p = new Object[]{cv.getCssText(), cv.getUnitType()};
        String s = Messages.formatMessage("invalid.value.access", p);
        return new DOMException(15, s);
    }
}

