/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.eclipse.parsson.JsonLocationImpl;
import org.eclipse.parsson.JsonMessages;

class JsonStructureParser
implements JsonParser {
    private Scope current;
    private JsonParser.Event state;
    private final Deque<Scope> scopeStack = new ArrayDeque<Scope>();

    JsonStructureParser(JsonArray array) {
        this.current = new ArrayScope(array);
    }

    JsonStructureParser(JsonObject object) {
        this.current = new ObjectScope(object);
    }

    @Override
    public String getString() {
        switch (this.state) {
            case KEY_NAME: {
                return ((ObjectScope)this.current).key;
            }
            case VALUE_STRING: {
                return ((JsonString)this.current.getJsonValue()).getString();
            }
            case VALUE_NUMBER: {
                return this.current.getJsonValue().toString();
            }
        }
        throw new IllegalStateException(JsonMessages.PARSER_GETSTRING_ERR(this.state));
    }

    private <T> T getNumberValue(Function<JsonNumber, T> numberFunction, Function<JsonParser.Event, String> exceptionMessageFunction) {
        if (this.state == JsonParser.Event.VALUE_NUMBER) {
            return numberFunction.apply((JsonNumber)this.current.getJsonValue());
        }
        throw new IllegalStateException(exceptionMessageFunction.apply(this.state));
    }

    @Override
    public boolean isIntegralNumber() {
        return this.getNumberValue(JsonNumber::isIntegral, JsonMessages::PARSER_ISINTEGRALNUMBER_ERR);
    }

    @Override
    public int getInt() {
        return this.getNumberValue(JsonNumber::intValue, JsonMessages::PARSER_GETINT_ERR);
    }

    @Override
    public long getLong() {
        return this.getNumberValue(JsonNumber::longValue, JsonMessages::PARSER_GETLONG_ERR);
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.getNumberValue(JsonNumber::bigDecimalValue, JsonMessages::PARSER_GETBIGDECIMAL_ERR);
    }

    @Override
    public JsonLocation getLocation() {
        return JsonLocationImpl.UNKNOWN;
    }

    @Override
    public boolean hasNext() {
        return this.state != JsonParser.Event.END_OBJECT && this.state != JsonParser.Event.END_ARRAY || !this.scopeStack.isEmpty();
    }

    @Override
    public JsonParser.Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.transition();
        return this.state;
    }

    private void transition() {
        if (this.state == null) {
            this.state = this.current instanceof ArrayScope ? JsonParser.Event.START_ARRAY : JsonParser.Event.START_OBJECT;
        } else {
            if (this.state == JsonParser.Event.END_OBJECT || this.state == JsonParser.Event.END_ARRAY) {
                this.current = this.scopeStack.pop();
            }
            if (this.current instanceof ArrayScope) {
                if (this.current.hasNext()) {
                    this.current.next();
                    this.nextStateAndEndOfTheObjectOrArray();
                } else {
                    this.state = JsonParser.Event.END_ARRAY;
                }
            } else if (this.state == JsonParser.Event.KEY_NAME) {
                this.nextStateAndEndOfTheObjectOrArray();
            } else if (this.current.hasNext()) {
                this.current.next();
                this.state = JsonParser.Event.KEY_NAME;
            } else {
                this.state = JsonParser.Event.END_OBJECT;
            }
        }
    }

    private void nextStateAndEndOfTheObjectOrArray() {
        this.state = JsonStructureParser.getState(this.current.getJsonValue());
        if (this.state == JsonParser.Event.START_ARRAY || this.state == JsonParser.Event.START_OBJECT) {
            this.scopeStack.push(this.current);
            this.current = Scope.createScope(this.current.getJsonValue());
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void skipObject() {
        if (this.current instanceof ObjectScope) {
            int depth = 1;
            do {
                if (this.state == JsonParser.Event.KEY_NAME) {
                    this.state = JsonStructureParser.getState(this.current.getJsonValue());
                    switch (this.state) {
                        case START_OBJECT: {
                            ++depth;
                            break;
                        }
                        case END_OBJECT: {
                            --depth;
                            break;
                        }
                    }
                    continue;
                }
                if (this.current.hasNext()) {
                    this.current.next();
                    this.state = JsonParser.Event.KEY_NAME;
                    continue;
                }
                this.state = JsonParser.Event.END_OBJECT;
                --depth;
            } while (this.state != JsonParser.Event.END_OBJECT && depth > 0);
        }
    }

    @Override
    public void skipArray() {
        if (this.current instanceof ArrayScope) {
            int depth = 1;
            do {
                if (this.current.hasNext()) {
                    this.current.next();
                    this.state = JsonStructureParser.getState(this.current.getJsonValue());
                    switch (this.state) {
                        case START_ARRAY: {
                            ++depth;
                            break;
                        }
                        case END_ARRAY: {
                            --depth;
                            break;
                        }
                    }
                    continue;
                }
                this.state = JsonParser.Event.END_ARRAY;
                --depth;
            } while (this.state != JsonParser.Event.END_ARRAY || depth != 0);
        }
    }

    private static JsonParser.Event getState(JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                return JsonParser.Event.START_ARRAY;
            }
            case OBJECT: {
                return JsonParser.Event.START_OBJECT;
            }
            case STRING: {
                return JsonParser.Event.VALUE_STRING;
            }
            case NUMBER: {
                return JsonParser.Event.VALUE_NUMBER;
            }
            case TRUE: {
                return JsonParser.Event.VALUE_TRUE;
            }
            case FALSE: {
                return JsonParser.Event.VALUE_FALSE;
            }
            case NULL: {
                return JsonParser.Event.VALUE_NULL;
            }
        }
        throw new JsonException(JsonMessages.PARSER_STATE_ERR(value.getValueType()));
    }

    private static class ObjectScope
    extends Scope {
        private final Iterator<Map.Entry<String, JsonValue>> it;
        private JsonValue value;
        private String key;

        ObjectScope(JsonObject object) {
            this.it = object.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Map.Entry<String, JsonValue> next() {
            Map.Entry<String, JsonValue> next = this.it.next();
            this.key = next.getKey();
            this.value = next.getValue();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        JsonValue getJsonValue() {
            return this.value;
        }
    }

    private static class ArrayScope
    extends Scope {
        private final Iterator<JsonValue> it;
        private JsonValue value;

        ArrayScope(JsonArray array) {
            this.it = array.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public JsonValue next() {
            this.value = this.it.next();
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        JsonValue getJsonValue() {
            return this.value;
        }
    }

    private static abstract class Scope
    implements Iterator {
        private Scope() {
        }

        abstract JsonValue getJsonValue();

        static Scope createScope(JsonValue value) {
            if (value instanceof JsonArray) {
                return new ArrayScope((JsonArray)value);
            }
            if (value instanceof JsonObject) {
                return new ObjectScope((JsonObject)value);
            }
            throw new JsonException(JsonMessages.PARSER_SCOPE_ERR(value));
        }
    }
}

