/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.utils.Bytes;

public final class BufferKey
implements Comparable<BufferKey> {
    private final long time;
    private final Bytes key;

    BufferKey(long time, Bytes key) {
        this.time = time;
        this.key = key;
    }

    long time() {
        return this.time;
    }

    Bytes key() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferKey bufferKey = (BufferKey)o;
        return this.time == bufferKey.time && Objects.equals(this.key, bufferKey.key);
    }

    public int hashCode() {
        return Objects.hash(this.time, this.key);
    }

    @Override
    public int compareTo(BufferKey o) {
        int timeComparison = Long.compare(this.time, o.time);
        return timeComparison == 0 ? this.key.compareTo(o.key) : timeComparison;
    }

    public String toString() {
        return "BufferKey{key=" + String.valueOf(this.key) + ", time=" + this.time + "}";
    }
}

