/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oracore.OracleType;

abstract class AccessorPrototype {
    private final short formOfUse;
    private final String columnName;
    private final int describeType;
    private final int describeMaxLength;
    private final int describeMaxLengthChars;
    private final boolean nullable;
    private final int precision;
    private final int scale;
    private final OracleType describeOtype;
    private final OracleResultSetMetaData.SecurityAttribute securityAttribute;
    private final boolean columnInvisible;
    private final boolean columnJSON;
    private final int oacmxl;
    private final ByteArray rowData;
    private final long[] rowOffset;
    private final int[] rowLength;
    private final boolean[] rowNull;
    private final byte[] rowMetadata;

    abstract Accessor newAccessor(OracleStatement var1) throws SQLException;

    protected AccessorPrototype(int numRows, Accessor acc, ByteArray stmtRowData) {
        this.formOfUse = acc.formOfUse;
        this.columnName = acc.columnName;
        this.describeType = acc.describeType;
        this.describeMaxLength = acc.describeMaxLength;
        this.describeMaxLengthChars = acc.describeMaxLengthChars;
        this.nullable = acc.nullable;
        this.precision = acc.precision;
        this.scale = acc.scale;
        this.describeOtype = acc.describeOtype;
        this.securityAttribute = acc.securityAttribute;
        this.columnInvisible = acc.columnInvisible;
        this.columnJSON = acc.columnJSON;
        this.oacmxl = acc.oacmxl;
        assert (numRows >= 0) : "numRows: " + numRows;
        assert (acc != null) : "null acc";
        assert (acc.rowOffset != null) : "null acc.rowOffset";
        assert (acc.rowOffset.length >= numRows) : "accRowOffset.length: " + acc.rowOffset.length + " numRows: " + numRows;
        assert (acc.rowLength != null) : "null acc.rowLength";
        assert (acc.rowLength.length >= numRows) : "accRowLength.length: " + acc.rowLength.length + " numRows: " + numRows;
        assert (acc.rowNull != null) : "null acc.rowNull";
        assert (acc.rowNull.length >= numRows) : "accRowNull.length: " + acc.rowLength.length + " numRows: " + numRows;
        assert (acc.rowMetadata != null) : "null acc.rowMetadata";
        assert (acc.rowMetadata.length >= numRows) : "accRowMetadata.length: " + acc.rowMetadata.length + " numRows: " + numRows;
        this.rowData = stmtRowData;
        this.rowOffset = Arrays.copyOfRange(acc.rowOffset, 0, numRows);
        this.rowLength = Arrays.copyOfRange(acc.rowLength, 0, numRows);
        this.rowNull = Arrays.copyOfRange(acc.rowNull, 0, numRows);
        this.rowMetadata = Arrays.copyOfRange(acc.rowMetadata, 0, numRows);
    }

    protected void initializeRowData(Accessor acc) {
        assert (acc != null) : "null acc";
        acc.columnName = this.columnName;
        acc.rowData = this.rowData;
        acc.rowOffset = this.rowOffset;
        acc.rowLength = this.rowLength;
        acc.rowNull = this.rowNull;
        acc.rowMetadata = this.rowMetadata;
    }
}

