"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = forecastFeature;
var _constants = require("../../utils/constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

function forecastFeature(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.forecast = components.clientAction.namespaceFactory();
  const forecast = Client.prototype.forecast.prototype;
  forecast.deleteForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  forecast.runOnceForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>/_run_once`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  forecast.createForecaster = ca({
    url: {
      fmt: _constants.API.FORECASTER_BASE
    },
    needBody: true,
    method: 'POST'
  });
  forecast.validateForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/_validate/<%=validationType%>`,
      req: {
        validationType: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  forecast.suggestForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/_suggest/<%=suggestType%>`,
      req: {
        suggestType: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  forecast.searchForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  forecast.searchTasks = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/tasks/_search`
    },
    needBody: true,
    method: 'POST'
  });
  forecast.updateForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  forecast.getForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>?job=true&task=true`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  forecast.searchResults = ca({
    url: {
      fmt: `/${_constants.DEFAULT_FORECAST_RESULT_INDEX_WILDCARD}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  forecast.searchResultsFromCustomResultIndex = ca({
    url: {
      fmt: `/<%=resultIndex%>/_search`,
      req: {
        resultIndex: {
          type: 'string',
          required: false
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  forecast.startForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>/_start`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  forecast.stopForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>/_stop`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  forecast.forecasterProfile = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>/_profile/init_progress,state,error`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  forecast.matchForecaster = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/match?name=<%=forecasterName%>`,
      req: {
        forecasterName: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'GET'
  });
  forecast.forecasterCount = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/count`
    },
    method: 'GET'
  });
  forecast.topForecastResults = ca({
    url: {
      fmt: `${_constants.API.FORECASTER_BASE}/<%=forecasterId%>/results/_topForecasts`,
      req: {
        forecasterId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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