/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.factory;

import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.env.Environment;
import org.opensearch.ingest.AbstractBatchingProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.SparseEncodingProcessor;
import org.opensearch.neuralsearch.processor.optimization.TextEmbeddingInferenceFilter;
import org.opensearch.neuralsearch.util.prune.PruneType;
import org.opensearch.neuralsearch.util.prune.PruneUtils;
import org.opensearch.transport.client.OpenSearchClient;

public class SparseEncodingProcessorFactory
extends AbstractBatchingProcessor.Factory {
    @Generated
    private static final Logger log = LogManager.getLogger(SparseEncodingProcessorFactory.class);
    private final OpenSearchClient openSearchClient;
    private final MLCommonsClientAccessor clientAccessor;
    private final Environment environment;
    private final ClusterService clusterService;

    public SparseEncodingProcessorFactory(OpenSearchClient openSearchClient, MLCommonsClientAccessor clientAccessor, Environment environment, ClusterService clusterService) {
        super("sparse_encoding");
        this.clientAccessor = clientAccessor;
        this.environment = environment;
        this.clusterService = clusterService;
        this.openSearchClient = openSearchClient;
    }

    protected AbstractBatchingProcessor newProcessor(String tag, String description, int batchSize, Map<String, Object> config) {
        String modelId = ConfigurationUtils.readStringProperty((String)"sparse_encoding", (String)tag, config, (String)"model_id");
        Map fieldMap = ConfigurationUtils.readMap((String)"sparse_encoding", (String)tag, config, (String)"field_map");
        boolean skipExisting = ConfigurationUtils.readBooleanProperty((String)"sparse_encoding", (String)tag, config, (String)"skip_existing", (boolean)false);
        PruneType pruneType = PruneType.fromString(ConfigurationUtils.readOptionalStringProperty((String)"sparse_encoding", (String)tag, config, (String)"prune_type"));
        float pruneRatio = 0.0f;
        if (pruneType != PruneType.NONE) {
            pruneRatio = ConfigurationUtils.readDoubleProperty((String)"sparse_encoding", (String)tag, config, (String)"prune_ratio").floatValue();
            if (!PruneUtils.isValidPruneRatio(pruneType, pruneRatio)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Illegal prune_ratio %f for prune_type: %s. %s", Float.valueOf(pruneRatio), pruneType.getValue(), PruneUtils.getValidPruneRatioDescription(pruneType)));
            }
        } else if (config.containsKey("prune_ratio")) {
            throw new IllegalArgumentException("prune_ratio field is not supported when prune_type is not provided");
        }
        return new SparseEncodingProcessor(tag, description, batchSize, modelId, fieldMap, skipExisting, skipExisting ? new TextEmbeddingInferenceFilter(fieldMap) : null, pruneType, pruneRatio, this.openSearchClient, this.clientAccessor, this.environment, this.clusterService);
    }
}

