/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.interceptors.StaticMembershipInterceptor;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.tribes.group.interceptors.TcpPingInterceptorMBean;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class TcpPingInterceptor
extends ChannelInterceptorBase
implements TcpPingInterceptorMBean {
    private static final Log log = LogFactory.getLog(TcpPingInterceptor.class);
    protected static final StringManager sm = StringManager.getManager(TcpPingInterceptor.class);
    protected static final byte[] TCP_PING_DATA = new byte[]{79, -89, 115, 72, 121, -33, 67, -55, -97, 111, -119, -128, -95, 91, 7, 20, 125, -39, 82, 91, -21, -33, 67, -102, -73, 126, -66, -113, -127, 103, 30, -74, 55, 21, -66, -121, 69, 33, 76, -88, -65, 10, 77, 19, 83, 56, 21, 50, 85, -10, -108, -73, 58, -33, 33, 120, -111, 4, 125, -41, 114, -124, -64, -43};
    protected long interval = 1000L;
    protected boolean useThread = false;
    protected boolean staticOnly = false;
    protected volatile boolean running = true;
    protected PingThread thread = null;
    protected static final AtomicInteger cnt = new AtomicInteger(0);
    WeakReference<TcpFailureDetector> failureDetector = null;
    WeakReference<StaticMembershipInterceptor> staticMembers = null;

    @Override
    public synchronized void start(int n) throws ChannelException {
        Object object;
        super.start(n);
        this.running = true;
        if (this.thread == null && this.useThread) {
            this.thread = new PingThread();
            this.thread.setDaemon(true);
            object = "";
            if (this.getChannel().getName() != null) {
                object = "[" + this.getChannel().getName() + "]";
            }
            this.thread.setName("TcpPingInterceptor.PingThread" + (String)object + "-" + cnt.addAndGet(1));
            this.thread.start();
        }
        for (object = this.getNext(); object != null; object = object.getNext()) {
            if (object instanceof TcpFailureDetector) {
                this.failureDetector = new WeakReference<TcpFailureDetector>((TcpFailureDetector)object);
            }
            if (!(object instanceof StaticMembershipInterceptor)) continue;
            this.staticMembers = new WeakReference<StaticMembershipInterceptor>((StaticMembershipInterceptor)object);
        }
    }

    @Override
    public synchronized void stop(int n) throws ChannelException {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        super.stop(n);
    }

    @Override
    public void heartbeat() {
        super.heartbeat();
        if (!this.getUseThread()) {
            this.sendPing();
        }
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long l) {
        this.interval = l;
    }

    public void setUseThread(boolean bl) {
        this.useThread = bl;
    }

    public void setStaticOnly(boolean bl) {
        this.staticOnly = bl;
    }

    @Override
    public boolean getUseThread() {
        return this.useThread;
    }

    public boolean getStaticOnly() {
        return this.staticOnly;
    }

    protected void sendPing() {
        TcpFailureDetector tcpFailureDetector;
        TcpFailureDetector tcpFailureDetector2 = tcpFailureDetector = this.failureDetector != null ? (TcpFailureDetector)this.failureDetector.get() : null;
        if (tcpFailureDetector != null) {
            tcpFailureDetector.checkMembers(true);
        } else {
            StaticMembershipInterceptor staticMembershipInterceptor;
            StaticMembershipInterceptor staticMembershipInterceptor2 = staticMembershipInterceptor = this.staticOnly && this.staticMembers != null ? (StaticMembershipInterceptor)this.staticMembers.get() : null;
            if (staticMembershipInterceptor != null) {
                this.sendPingMessage(staticMembershipInterceptor.getMembers());
            } else {
                this.sendPingMessage(this.getMembers());
            }
        }
    }

    protected void sendPingMessage(Member[] memberArray) {
        if (memberArray == null || memberArray.length == 0) {
            return;
        }
        ChannelData channelData = new ChannelData(true);
        channelData.setAddress(this.getLocalMember(false));
        channelData.setTimestamp(System.currentTimeMillis());
        channelData.setOptions(this.getOptionFlag());
        channelData.setMessage(new XByteBuffer(TCP_PING_DATA, false));
        try {
            super.sendMessage(memberArray, channelData, null);
        }
        catch (ChannelException channelException) {
            log.warn((Object)sm.getString("tcpPingInterceptor.ping.failed"), (Throwable)channelException);
        }
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        boolean bl = true;
        if (this.okToProcess(channelMessage.getOptions())) {
            boolean bl2 = bl = channelMessage.getMessage().getLength() != TCP_PING_DATA.length || !Arrays.equals(TCP_PING_DATA, channelMessage.getMessage().getBytes());
        }
        if (bl) {
            super.messageReceived(channelMessage);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Received a TCP ping packet:" + String.valueOf(channelMessage)));
        }
    }

    protected class PingThread
    extends Thread {
        protected PingThread() {
        }

        @Override
        public void run() {
            while (TcpPingInterceptor.this.running) {
                try {
                    PingThread.sleep(TcpPingInterceptor.this.interval);
                    TcpPingInterceptor.this.sendPing();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("tcpPingInterceptor.pingFailed.pingThread"), (Throwable)exception);
                }
            }
        }
    }
}

