﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>
#include <aws/imagebuilder/model/SeverityCounts.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace imagebuilder {
namespace Model {

/**
 * <p>Includes counts of image and pipeline resource findings by
 * vulnerability.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/VulnerabilityIdAggregation">AWS
 * API Reference</a></p>
 */
class VulnerabilityIdAggregation {
 public:
  AWS_IMAGEBUILDER_API VulnerabilityIdAggregation() = default;
  AWS_IMAGEBUILDER_API VulnerabilityIdAggregation(Aws::Utils::Json::JsonView jsonValue);
  AWS_IMAGEBUILDER_API VulnerabilityIdAggregation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IMAGEBUILDER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The vulnerability Id for this set of counts.</p>
   */
  inline const Aws::String& GetVulnerabilityId() const { return m_vulnerabilityId; }
  inline bool VulnerabilityIdHasBeenSet() const { return m_vulnerabilityIdHasBeenSet; }
  template <typename VulnerabilityIdT = Aws::String>
  void SetVulnerabilityId(VulnerabilityIdT&& value) {
    m_vulnerabilityIdHasBeenSet = true;
    m_vulnerabilityId = std::forward<VulnerabilityIdT>(value);
  }
  template <typename VulnerabilityIdT = Aws::String>
  VulnerabilityIdAggregation& WithVulnerabilityId(VulnerabilityIdT&& value) {
    SetVulnerabilityId(std::forward<VulnerabilityIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Counts by severity level for medium severity and higher level findings, plus
   * a total for all of the findings for the specified vulnerability.</p>
   */
  inline const SeverityCounts& GetSeverityCounts() const { return m_severityCounts; }
  inline bool SeverityCountsHasBeenSet() const { return m_severityCountsHasBeenSet; }
  template <typename SeverityCountsT = SeverityCounts>
  void SetSeverityCounts(SeverityCountsT&& value) {
    m_severityCountsHasBeenSet = true;
    m_severityCounts = std::forward<SeverityCountsT>(value);
  }
  template <typename SeverityCountsT = SeverityCounts>
  VulnerabilityIdAggregation& WithSeverityCounts(SeverityCountsT&& value) {
    SetSeverityCounts(std::forward<SeverityCountsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_vulnerabilityId;

  SeverityCounts m_severityCounts;
  bool m_vulnerabilityIdHasBeenSet = false;
  bool m_severityCountsHasBeenSet = false;
};

}  // namespace Model
}  // namespace imagebuilder
}  // namespace Aws
