/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import generic.theme.GColor;
import ghidra.docking.util.LookAndFeelUtils;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import resources.ResourceManager;

public class EmptyBorderButton
extends JButton {
    private ButtonStateListener emptyBorderButtonChangeListener;
    private ButtonFocusListener emptyBorderButtonFocusListener;
    public static final Border RAISED_BUTTON_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    public static final Border NO_BUTTON_BORDER = new EmptyBorder(RAISED_BUTTON_BORDER.getBorderInsets(new JButton()));
    public static final Border LOWERED_BUTTON_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    private static final Color FOCUS_COLOR = new GColor("color.border.button.focused");
    public static final Border FOCUSED_BUTTON_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createLineBorder(FOCUS_COLOR));

    public EmptyBorderButton() {
        this.init();
    }

    public EmptyBorderButton(String text) {
        super(text);
        this.init();
    }

    public EmptyBorderButton(Action a) {
        super(a);
        this.init();
    }

    public EmptyBorderButton(Icon icon) {
        super(icon);
        this.init();
    }

    public EmptyBorderButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    private void init() {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.installLookAndFeelFix();
        this.clearBorder();
        this.emptyBorderButtonChangeListener = new ButtonStateListener();
        this.emptyBorderButtonFocusListener = new ButtonFocusListener();
        this.addChangeListener(this.emptyBorderButtonChangeListener);
        this.addFocusListener(this.emptyBorderButtonFocusListener);
    }

    @Override
    public void setIcon(Icon newIcon) {
        ImageIcon disabledIcon = ResourceManager.getDisabledIcon((Icon)newIcon);
        this.setDisabledIcon(disabledIcon);
        super.setIcon(newIcon);
    }

    @Override
    public void setBorder(Border border) {
        if (border == RAISED_BUTTON_BORDER || border == LOWERED_BUTTON_BORDER || border == FOCUSED_BUTTON_BORDER || border == NO_BUTTON_BORDER) {
            super.setBorder(border);
        }
    }

    private void installLookAndFeelFix() {
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        if (LookAndFeelUtils.isUsingAquaUI(this.getUI())) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (e.getButton() == 0) {
                        EmptyBorderButton.this.raiseBorder();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    EmptyBorderButton.this.clearBorder();
                }
            });
        }
    }

    public void raiseBorder() {
        this.setBorder(this.getRaisedBorder());
    }

    public void clearBorder() {
        this.setBorder(NO_BUTTON_BORDER);
    }

    protected void updateBorderBasedOnState() {
        if (!this.isEnabled()) {
            return;
        }
        ButtonModel buttonModel = this.getModel();
        boolean pressed = buttonModel.isPressed();
        boolean rollover = buttonModel.isRollover();
        boolean armed = buttonModel.isArmed();
        if (pressed && (rollover || armed)) {
            this.setBorder(this.getLoweredBorder());
        } else if (rollover) {
            this.setBorder(this.getRaisedBorder());
        } else if (this.isFocusOwner()) {
            this.setBorder(this.getFocusedBorder());
        } else {
            this.setBorder(NO_BUTTON_BORDER);
        }
    }

    protected Border getFocusedBorder() {
        return FOCUSED_BUTTON_BORDER;
    }

    protected Border getRaisedBorder() {
        return RAISED_BUTTON_BORDER;
    }

    protected Border getLoweredBorder() {
        return LOWERED_BUTTON_BORDER;
    }

    public void removeListeners() {
        this.removeChangeListener(this.emptyBorderButtonChangeListener);
        this.removeFocusListener(this.emptyBorderButtonFocusListener);
    }

    private class ButtonStateListener
    implements ChangeListener {
        private ButtonStateListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            EmptyBorderButton.this.updateBorderBasedOnState();
        }
    }

    private class ButtonFocusListener
    implements FocusListener {
        private ButtonFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            EmptyBorderButton.this.updateBorderBasedOnState();
        }

        @Override
        public void focusLost(FocusEvent e) {
            EmptyBorderButton.this.updateBorderBasedOnState();
        }
    }
}

