/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.vfs.dropbox;

import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.rzo.vfs.dropbox.DropboxFileSystem;

public final class DropboxFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final DropboxFileSystemConfigBuilder BUILDER = new DropboxFileSystemConfigBuilder();
    private static final String DATA_TIMEOUT = String.valueOf(DropboxFileSystemConfigBuilder.class.getName()) + ".DATA_TIMEOUT";
    private static final String SO_TIMEOUT = String.valueOf(DropboxFileSystemConfigBuilder.class.getName()) + ".SO_TIMEOUT";
    private static final String ENCODING = String.valueOf(DropboxFileSystemConfigBuilder.class.getName()) + ".ENCODING";

    private DropboxFileSystemConfigBuilder() {
        super("dbx.");
    }

    public static DropboxFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return DropboxFileSystem.class;
    }

    public Integer getDataTimeout(FileSystemOptions opts) {
        return this.getInteger(opts, DATA_TIMEOUT);
    }

    public void setDataTimeout(FileSystemOptions opts, Integer dataTimeout) {
        this.setParam(opts, DATA_TIMEOUT, dataTimeout);
    }

    public Integer getSoTimeout(FileSystemOptions opts) {
        return (Integer)this.getParam(opts, SO_TIMEOUT);
    }

    public void setSoTimeout(FileSystemOptions opts, Integer soTimeout) {
        this.setParam(opts, SO_TIMEOUT, soTimeout);
    }

    public void setControlEncoding(FileSystemOptions opts, String encoding) {
        this.setParam(opts, ENCODING, encoding);
    }

    public String getControlEncoding(FileSystemOptions opts) {
        return (String)this.getParam(opts, ENCODING);
    }
}

