/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.app.plugin.processors.generic.ConstantTemplate;
import ghidra.app.plugin.processors.generic.Handle;
import ghidra.app.plugin.processors.generic.OpTemplate;
import ghidra.app.plugin.processors.generic.Operand;
import ghidra.app.plugin.processors.generic.Position;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.Varnode;
import java.io.Serializable;
import java.util.HashMap;

public class VarnodeTemplate
implements Serializable {
    private boolean loadomit;
    private Operand replace;
    private AddressFactory addressFactory;
    private int hashCode;
    private ConstantTemplate space;
    private ConstantTemplate offset;
    private ConstantTemplate size;
    private boolean oneuse = false;

    public VarnodeTemplate(ConstantTemplate space, ConstantTemplate offset, ConstantTemplate size, AddressFactory addressFactory, boolean ou) {
        this.space = space;
        this.offset = offset;
        this.size = size;
        this.addressFactory = addressFactory;
        this.oneuse = ou;
        this.hashCode = space.hashCode() + offset.hashCode() + size.hashCode();
        if (this.oneuse) {
            ++this.hashCode;
        }
    }

    public void setDef(OpTemplate opTemplate) {
    }

    public Varnode resolve(HashMap<Object, Handle> handles, Position position, int bufoff) throws Exception {
        int sz;
        long off;
        int spaceID;
        if (this.replace != null && !this.replace.dynamic()) {
            Handle h = this.replace.getHandle();
            spaceID = (int)h.getLong(0, 0);
            off = h.getLong(1, 1);
            sz = (int)h.getLong(2, 0);
        } else {
            spaceID = (int)this.space.resolve(handles, position, bufoff);
            off = this.offset.resolve(handles, position, bufoff);
            sz = (int)this.size.resolve(handles, position, bufoff);
        }
        Address addr = this.getMaskedAddr(spaceID, off);
        return new Varnode(addr, sz);
    }

    public Varnode resolve(Position position, int bufoff) throws Exception {
        int spaceID = (int)this.space.resolve(position, bufoff);
        long off = this.offset.resolve(position, bufoff);
        int sz = (int)this.size.resolve(position, bufoff);
        Address addr = this.getMaskedAddr(spaceID, off);
        return new Varnode(addr, sz);
    }

    private Address getMaskedAddr(int spaceID, long off) {
        AddressSpace mySpace = this.addressFactory.getAddressSpace(spaceID);
        return mySpace.getTruncatedAddress(off, false);
    }

    public boolean oneuse() {
        return this.oneuse;
    }

    public ConstantTemplate space() {
        return this.space;
    }

    public ConstantTemplate offset() {
        return this.offset;
    }

    public ConstantTemplate size() {
        return this.size;
    }

    public void setReplace(Operand op, boolean load) {
        this.replace = op;
        if (load) {
            this.loadomit = true;
        }
    }

    public boolean loadomit() {
        return this.loadomit;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o.getClass() != VarnodeTemplate.class) {
            return false;
        }
        VarnodeTemplate vt = (VarnodeTemplate)o;
        if (vt.hashCode() != this.hashCode) {
            return false;
        }
        if (!vt.space().equals(this.space)) {
            return false;
        }
        if (!vt.offset().equals(this.offset)) {
            return false;
        }
        return vt.size().equals(this.size);
    }
}

