/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.VariableLocation;

public class VariableNameFieldLocation
extends VariableLocation {
    private String name;

    public VariableNameFieldLocation(Program program, Address locationAddr, Variable var, int charOffset) {
        super(program, locationAddr, var, 0, charOffset);
        this.name = var.getName();
    }

    public VariableNameFieldLocation(Program program, Variable var, int charOffset) {
        super(program, var, 0, charOffset);
        this.name = var.getName();
    }

    public VariableNameFieldLocation() {
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableNameFieldLocation other = (VariableNameFieldLocation)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.name = obj.getString("_VAR_NAME", null);
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_VAR_NAME", this.name);
    }
}

