/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.sugiyama.GraphLayers;
import org.jungrapht.visualization.layout.algorithms.sugiyama.GreedyCycleRemoval;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Synthetics;
import org.jungrapht.visualization.layout.algorithms.sugiyama.TransformedGraphSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrandesKopf<V, E> {
    private static final Logger log = LoggerFactory.getLogger(BrandesKopf.class);
    Graph<V, E> originalGraph;
    LV<V>[][] layersArray;
    Graph<LV<V>, LE<V, E>> svGraph;

    public BrandesKopf(Graph<V, E> originalGraph) {
        this.originalGraph = originalGraph;
        this.svGraph = new TransformedGraphSupplier<V, E>(originalGraph).get();
        GreedyCycleRemoval<LV<V>, LE<V, E>> greedyCycleRemoval = new GreedyCycleRemoval<LV<V>, LE<V, E>>(this.svGraph);
        Collection<LE<V, E>> feedbackArcs = greedyCycleRemoval.getFeedbackArcs();
        for (LE<V, E> se : feedbackArcs) {
            this.svGraph.removeEdge(se);
            LE newEdge = LE.of(se.getEdge(), se.getTarget(), se.getSource());
            this.svGraph.addEdge(newEdge.getSource(), newEdge.getTarget(), newEdge);
        }
        List<List<LV<V>>> layers = GraphLayers.assign(this.svGraph);
        if (log.isTraceEnabled()) {
            GraphLayers.checkLayers(layers);
        }
        Synthetics synthetics = new Synthetics(this.svGraph);
        ArrayList edges = new ArrayList(this.svGraph.edgeSet());
        this.layersArray = synthetics.createVirtualVerticesAndEdges(edges, layers);
    }
}

