/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.panel;

import ghidra.features.base.codecompare.panel.ComparisonData;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import java.awt.Color;
import java.util.Objects;

public class FunctionComparisonData
implements ComparisonData {
    private final Function function;

    public FunctionComparisonData(Function function) {
        this.function = Objects.requireNonNull(function);
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public AddressSetView getAddressSet() {
        if (this.function.isExternal()) {
            return new AddressSet(this.function.getEntryPoint(), this.function.getEntryPoint());
        }
        return this.function.getBody();
    }

    @Override
    public Program getProgram() {
        return this.function.getProgram();
    }

    @Override
    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        String padStr = HTMLUtilities.spaces((int)4);
        buf.append(padStr);
        String functionStr = HTMLUtilities.friendlyEncodeHTML((String)(this.function.getName(true) + "()"));
        String specialFunctionStr = HTMLUtilities.bold((String)functionStr);
        buf.append(specialFunctionStr);
        Program program = this.function.getProgram();
        if (program != null) {
            buf.append(" in ");
            String programStr = HTMLUtilities.friendlyEncodeHTML((String)program.getDomainFile().getPathname());
            String specialProgramStr = HTMLUtilities.colorString((Color)FG_COLOR_TITLE, (String)programStr);
            buf.append(specialProgramStr);
            buf.append(padStr);
        }
        return HTMLUtilities.wrapAsHTML((String)buf.toString());
    }

    @Override
    public String getShortDescription() {
        return this.function.getName();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public ProgramLocation getInitialLocation() {
        return new FunctionSignatureFieldLocation(this.function.getProgram(), this.function.getEntryPoint());
    }
}

