/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.var;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.var.ValGen;
import ghidra.pcode.emu.jit.var.JitConstVal;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum ConstValGen implements ValGen<JitConstVal>
{
    GEN;


    @Override
    public void generateValInitCode(JitCodeGenerator gen, JitConstVal v, MethodVisitor iv) {
    }

    @Override
    public JitType generateValReadCode(JitCodeGenerator gen, JitConstVal v, JitTypeBehavior typeReq, MethodVisitor rv) {
        JitType type;
        JitType jitType = type = typeReq.resolve(gen.getTypeModel().typeOf(v));
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                rv.visitLdcInsn((Object)v.value().intValue());
                break;
            }
            case 1: {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                rv.visitLdcInsn((Object)v.value().longValue());
                break;
            }
            case 2: {
                JitType.FloatJitType t = (JitType.FloatJitType)jitType2;
                rv.visitLdcInsn((Object)Float.valueOf(Float.intBitsToFloat(v.value().intValue())));
                break;
            }
            case 3: {
                JitType.DoubleJitType t = (JitType.DoubleJitType)jitType2;
                rv.visitLdcInsn((Object)Double.longBitsToDouble(v.value().longValue()));
                break;
            }
            case 4: {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                int count = t.legsAlloc();
                for (int i = 0; i < count; ++i) {
                    int leg = v.value().shiftRight(32 * (count - 1 - i)).intValue();
                    rv.visitLdcInsn((Object)leg);
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return type;
    }
}

