/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;

public class Beanify {
    public static Map<String, Object> beanify(Object beany) {
        Field[] declaredFields;
        Method[] declaredMethods;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Class<?> bclass = beany.getClass();
        for (Method method : declaredMethods = bclass.getDeclaredMethods()) {
            String name = Beanify.fix(method.getName());
            if (name == null || !Modifier.isPublic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            try {
                method.setAccessible(true);
                Object thing = method.invoke(beany, new Object[0]);
                result.put(name, thing);
            }
            catch (Exception e) {
                result.put(name, e.toString());
            }
        }
        for (Field field : declaredFields = bclass.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers())) continue;
            String name = field.getName();
            try {
                field.setAccessible(true);
                Object thing = field.get(beany);
                result.put(name, thing);
            }
            catch (Exception e) {
                result.put(name, e.toString());
            }
        }
        return result;
    }

    private static String fix(String name) {
        if (name.startsWith("get") && name.length() > 3) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        if (name.startsWith("is") && name.length() > 2) {
            return name.substring(2, 3).toLowerCase() + name.substring(3);
        }
        return null;
    }
}

