/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.awt.Shape;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.Graph;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.util.RadiusVertexAccessor;

public class RadiusGraphElementAccessor<V, E>
extends RadiusVertexAccessor<V>
implements GraphElementAccessor<V, E> {
    public RadiusGraphElementAccessor() {
        this(Math.sqrt(Double.MAX_VALUE));
    }

    public RadiusGraphElementAccessor(double maxDistance) {
        super(maxDistance);
    }

    public E getEdge(LayoutModel<V> layoutModel, Point p) {
        return this.getEdge(layoutModel, p.x, p.y);
    }

    public E getEdge(LayoutModel<V> layoutModel, double x, double y) {
        Graph graph = layoutModel.getGraph();
        double minDistance = this.maxDistance * this.maxDistance;
        E closest = null;
        while (true) {
            try {
                for (Object edge : graph.edgeSet()) {
                    double distance2;
                    Object vertex1 = graph.getEdgeSource(edge);
                    Object vertex2 = graph.getEdgeTarget(edge);
                    Point p1 = (Point)layoutModel.apply(vertex1);
                    Point p2 = (Point)layoutModel.apply(vertex2);
                    double x1 = p1.x;
                    double y1 = p1.y;
                    double x2 = p2.x;
                    double y2 = p2.y;
                    if (x1 == x2 && y1 == y2) continue;
                    double b = ((y - y1) * (y2 - y1) + (x - x1) * (x2 - x1)) / ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    if (b <= 0.0) {
                        distance2 = (x - x1) * (x - x1) + (y - y1) * (y - y1);
                    } else if (b >= 1.0) {
                        distance2 = (x - x2) * (x - x2) + (y - y2) * (y - y2);
                    } else {
                        double x3 = x1 + b * (x2 - x1);
                        double y3 = y1 + b * (y2 - y1);
                        distance2 = (x - x3) * (x - x3) + (y - y3) * (y - y3);
                    }
                    if (!(distance2 < minDistance)) continue;
                    minDistance = distance2;
                    closest = edge;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    @Override
    public Set<V> getVertices(LayoutModel<V> layoutModel, Shape rectangle) {
        HashSet pickedvertices = new HashSet();
        while (true) {
            try {
                for (Object vertex : layoutModel.getGraph().vertexSet()) {
                    Point p = (Point)layoutModel.apply(vertex);
                    if (!rectangle.contains(p.x, p.y)) continue;
                    pickedvertices.add(vertex);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return pickedvertices;
    }
}

