/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.EndMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.BlockNestingContext;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DeferrableFunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestableSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestingSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractBlockContextApplier
extends MsSymbolApplier
implements DeferrableFunctionSymbolApplier,
NestingSymbolApplier {
    protected BlockNestingContext context;
    protected long specifiedFrameSize = 0L;

    public AbstractBlockContextApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    void initContext() {
        this.context = new BlockNestingContext(this.applicator);
    }

    @Override
    public void beginBlock(Address startAddress, String name, long length) {
        this.context.beginBlock(startAddress, name, length);
    }

    @Override
    public void endBlock() {
        this.context.endBlock();
    }

    void setSpecifiedFrameSize(long specifiedFrameSize) {
        this.specifiedFrameSize = specifiedFrameSize;
    }

    protected boolean notDone(BlockNestingContext blockNestingContext, MsSymbolIterator iter) {
        return blockNestingContext.notDone() && iter.hasNext();
    }

    protected boolean processEndSymbol(long endOffset, MsSymbolIterator iter) {
        boolean success;
        iter.initGetByOffset(endOffset);
        AbstractMsSymbol subSymbol = iter.peek();
        if (subSymbol instanceof EndMsSymbol) {
            EndMsSymbol endSymbol = (EndMsSymbol)subSymbol;
            v0 = true;
        } else {
            v0 = success = false;
        }
        if (success) {
            iter.next();
        } else {
            this.applicator.appendLogMsg("PDB: Expecting EndMsSymbol termation of function but found " + subSymbol.getClass().getSimpleName());
        }
        return success;
    }

    protected void deferredProcessing(MsSymbolIterator iter, String name, Address address, Address blockAddress, long length) throws CancelledException, PdbException {
        long currentFrameSize = 0L;
        this.initContext();
        this.context.beginBlock(blockAddress, name, length);
        while (this.notDone(this.context, iter)) {
            this.applicator.checkCancelled();
            AbstractMsSymbol subSymbol = iter.peek();
            MsSymbolApplier applier = this.applicator.getSymbolApplier(subSymbol, iter);
            if (applier instanceof NestableSymbolApplier) {
                NestableSymbolApplier nestingApplier = (NestableSymbolApplier)((Object)applier);
                nestingApplier.applyTo(this, iter);
                continue;
            }
            this.applicator.getPdbApplicatorMetrics().witnessNonNestableSymbolType(subSymbol);
            iter.next();
        }
        this.context.getComments().applyTo(this.applicator.getProgram(), 0L);
    }

    abstract long getStartOffset();

    abstract long getEndOffset();

    protected static class RegisterChangeCalculator {
        private Map<Register, Integer> registerChangeByRegisterName = new HashMap<Register, Integer>();
        private CallDepthChangeInfo callDepthChangeInfo;
        private Address debugStart;

        RegisterChangeCalculator(AbstractProcedureMsSymbol procedureSymbol, Function function, TaskMonitor monitor) throws CancelledException {
            this.callDepthChangeInfo = this.createCallDepthChangInfo(procedureSymbol, function, monitor);
        }

        private CallDepthChangeInfo createCallDepthChangInfo(AbstractProcedureMsSymbol procedureSymbol, Function function, TaskMonitor monitor) throws CancelledException {
            if (procedureSymbol == null) {
                return null;
            }
            Register frameReg = function.getProgram().getCompilerSpec().getStackPointer();
            Address entryAddr = function.getEntryPoint();
            this.debugStart = entryAddr.add(procedureSymbol.getDebugStartOffset());
            AddressSet scopeSet = new AddressSet();
            scopeSet.addRange(entryAddr, this.debugStart);
            return new CallDepthChangeInfo(function, (AddressSetView)scopeSet, frameReg, monitor);
        }

        Integer getRegChange(DefaultPdbApplicator applicator, Register register) {
            if (this.callDepthChangeInfo == null || register == null) {
                return null;
            }
            Integer change = this.registerChangeByRegisterName.get(register);
            if (change != null) {
                return change;
            }
            change = this.callDepthChangeInfo.getRegDepth(this.debugStart, register);
            this.registerChangeByRegisterName.put(register, change);
            return change;
        }
    }
}

