/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogModel;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogsModel;
import com.android.tools.idea.gradle.dsl.api.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleVersionCatalogModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleVersionCatalogPropertyModel;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleVersionCatalogsModelImpl
implements GradleVersionCatalogsModel {
    private Map<String, GradleVersionCatalogFile> versionCatalogFiles;
    private BuildModelContext buildModelContext;

    GradleVersionCatalogsModelImpl(@NotNull Collection<GradleVersionCatalogFile> versionCatalogFile, BuildModelContext buildModelContext) {
        if (versionCatalogFile == null) {
            GradleVersionCatalogsModelImpl.$$$reportNull$$$0(0);
        }
        this.versionCatalogFiles = versionCatalogFile.stream().collect(Collectors.toMap(GradleVersionCatalogFile::getCatalogName, Function.identity()));
        this.buildModelContext = buildModelContext;
    }

    private Map<String, ExtModel> extractByName(String sectionName) {
        return this.versionCatalogFiles.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, keyValue -> {
            GradleDslExpressionMap librariesDslElement = ((GradleVersionCatalogFile)keyValue.getValue()).ensurePropertyElement(new PropertiesElementDescription<GradleDslExpressionMap>(sectionName, GradleDslExpressionMap.class, GradleDslExpressionMap::new));
            return new ExtModelImpl(librariesDslElement, GradleVersionCatalogPropertyModel::new, (Function3<GradlePropertiesDslElement, PropertyType, String, GradlePropertyModel>)((Function3)GradleVersionCatalogPropertyModel::new));
        }));
    }

    @Override
    @Nullable
    public ExtModel libraries(String catalogName) {
        return this.extractByName("libraries").get(catalogName);
    }

    @Override
    @Nullable
    public ExtModel plugins(String catalogName) {
        return this.extractByName("plugins").get(catalogName);
    }

    @Override
    @Nullable
    public ExtModel versions(String catalogName) {
        return this.extractByName("versions").get(catalogName);
    }

    @Override
    @Nullable
    public ExtModel bundles(String catalogName) {
        return this.extractByName("bundles").get(catalogName);
    }

    @Override
    @NotNull
    public Set<String> catalogNames() {
        Set<String> set = this.versionCatalogFiles.keySet();
        if (set == null) {
            GradleVersionCatalogsModelImpl.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @Nullable
    public GradleVersionCatalogModel getVersionCatalogModel(String catalogName) {
        GradleVersionCatalogFile file = this.versionCatalogFiles.get(catalogName);
        if (file == null) {
            return null;
        }
        return new GradleVersionCatalogModelImpl(file);
    }

    @Override
    @NotNull
    public GradleVersionCatalogModel getVersionCatalogModel(VirtualFile file, String catalogName) {
        GradleVersionCatalogFile catalogFile = this.buildModelContext.getOrCreateVersionCatalogFile(file, catalogName);
        return new GradleVersionCatalogModelImpl(catalogFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionCatalogFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/GradleVersionCatalogsModelImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleVersionCatalogsModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "catalogNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

