/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.assertj.core.util.Preconditions;

public class DateUtil {
    private static final DateFormat ISO_DATE_FORMAT = DateUtil.newIsoDateFormat();
    private static final DateFormat ISO_DATE_TIME_FORMAT = DateUtil.newIsoDateTimeFormat();
    private static final DateFormat ISO_DATE_TIME_FORMAT_WITH_MS = DateUtil.newIsoDateTimeWithMsFormat();

    public static DateFormat newIsoDateFormat() {
        return DateUtil.newIsoDateFormat(false);
    }

    public static DateFormat newIsoDateTimeWithIsoTimeZoneFormat() {
        return DateUtil.newIsoDateTimeWithIsoTimeZoneFormat(false);
    }

    public static DateFormat newIsoDateTimeFormat() {
        return DateUtil.newIsoDateTimeFormat(false);
    }

    public static DateFormat newIsoDateTimeWithMsFormat() {
        return DateUtil.newIsoDateTimeWithMsFormat(false);
    }

    public static DateFormat newIsoDateTimeWithMsAndIsoTimeZoneFormat() {
        return DateUtil.newIsoDateTimeWithMsAndIsoTimeZoneFormat(false);
    }

    public static DateFormat newTimestampDateFormat() {
        return DateUtil.newTimestampDateFormat(false);
    }

    public static DateFormat newIsoDateFormat(boolean lenientParsing) {
        return DateUtil.dateFormatForPattern("yyyy-MM-dd", lenientParsing);
    }

    public static DateFormat newIsoDateTimeWithIsoTimeZoneFormat(boolean lenientParsing) {
        return DateUtil.dateFormatForPattern("yyyy-MM-dd'T'HH:mm:ssX", lenientParsing);
    }

    public static DateFormat newIsoDateTimeFormat(boolean lenientParsing) {
        return DateUtil.dateFormatForPattern("yyyy-MM-dd'T'HH:mm:ss", lenientParsing);
    }

    public static DateFormat newIsoDateTimeWithMsFormat(boolean lenientParsing) {
        return DateUtil.dateFormatForPattern("yyyy-MM-dd'T'HH:mm:ss.SSS", lenientParsing);
    }

    public static DateFormat newIsoDateTimeWithMsAndIsoTimeZoneFormat(boolean lenientParsing) {
        return DateUtil.dateFormatForPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX", lenientParsing);
    }

    public static DateFormat newTimestampDateFormat(boolean lenientParsing) {
        return DateUtil.dateFormatForPattern("yyyy-MM-dd HH:mm:ss.SSS", lenientParsing);
    }

    private static DateFormat dateFormatForPattern(String pattern, boolean lenient) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setLenient(lenient);
        return dateFormat;
    }

    public static synchronized String formatAsDatetime(Date date) {
        return date == null ? null : ISO_DATE_TIME_FORMAT.format(date);
    }

    public static synchronized String formatAsDatetimeWithMs(Date date) {
        return date == null ? null : ISO_DATE_TIME_FORMAT_WITH_MS.format(date);
    }

    public static String formatAsDatetime(Calendar calendar) {
        return calendar == null ? null : DateUtil.formatAsDatetime(calendar.getTime());
    }

    public static synchronized Date parse(String dateAsString) {
        try {
            return dateAsString == null ? null : ISO_DATE_FORMAT.parse(dateAsString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized Date parseDatetime(String dateAsString) {
        try {
            return dateAsString == null ? null : ISO_DATE_TIME_FORMAT.parse(dateAsString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized Date parseDatetimeWithMs(String dateAsString) {
        try {
            return dateAsString == null ? null : ISO_DATE_TIME_FORMAT_WITH_MS.parse(dateAsString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Calendar toCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static int yearOf(Date date) {
        return DateUtil.toCalendar(date).get(1);
    }

    public static int monthOf(Date date) {
        return DateUtil.toCalendar(date).get(2) + 1;
    }

    public static int dayOfMonthOf(Date date) {
        return DateUtil.toCalendar(date).get(5);
    }

    public static int dayOfWeekOf(Date date) {
        return DateUtil.toCalendar(date).get(7);
    }

    public static int hourOfDayOf(Date date) {
        return DateUtil.toCalendar(date).get(11);
    }

    public static int minuteOf(Date date) {
        return DateUtil.toCalendar(date).get(12);
    }

    public static int secondOf(Date date) {
        return DateUtil.toCalendar(date).get(13);
    }

    public static int millisecondOf(Date date) {
        return DateUtil.toCalendar(date).get(14);
    }

    public static long timeDifference(Date date1, Date date2) {
        Preconditions.checkArgument(date1 != null && date2 != null, "Expecting date parameter not to be null", new Object[0]);
        return Math.abs(date1.getTime() - date2.getTime());
    }

    public static Date truncateTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtil.toCalendar(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date now() {
        return new Date();
    }

    public static Date yesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date tomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        return cal.getTime();
    }

    public static String formatTimeDifference(Date date1, Date date2) {
        boolean notFirstDiff;
        long millisecondsDiff = DateUtil.timeDifference(date1, date2);
        long secondsDiff = millisecondsDiff / TimeUnit.SECONDS.toMillis(1L);
        long minutesDiff = millisecondsDiff / TimeUnit.MINUTES.toMillis(1L);
        long hoursDiff = millisecondsDiff / TimeUnit.HOURS.toMillis(1L);
        long daysDiff = millisecondsDiff / TimeUnit.DAYS.toMillis(1L);
        long hourFieldDiff = hoursDiff - TimeUnit.DAYS.toHours(daysDiff);
        long minuteFieldDiff = minutesDiff - TimeUnit.HOURS.toMinutes(hoursDiff);
        long secondFieldDiff = secondsDiff - TimeUnit.MINUTES.toSeconds(minutesDiff);
        long millisecondsFieldDiff = millisecondsDiff % TimeUnit.SECONDS.toMillis(1L);
        StringBuilder result = new StringBuilder();
        if (daysDiff > 0L) {
            result.append(String.format("%dd", daysDiff));
        }
        if (hourFieldDiff > 0L) {
            if (daysDiff > 0L && minuteFieldDiff == 0L && secondFieldDiff == 0L && millisecondsFieldDiff == 0L) {
                result.append(" and ");
            } else if (daysDiff > 0L) {
                result.append(" ");
            }
            result.append(String.format("%dh", hourFieldDiff));
        }
        if (minuteFieldDiff > 0L) {
            boolean bl = notFirstDiff = daysDiff > 0L || hourFieldDiff > 0L;
            if (notFirstDiff && secondFieldDiff == 0L && millisecondsFieldDiff == 0L) {
                result.append(" and ");
            } else if (notFirstDiff) {
                result.append(" ");
            }
            result.append(String.format("%dm", minuteFieldDiff));
        }
        if (secondFieldDiff > 0L) {
            boolean bl = notFirstDiff = daysDiff > 0L || hourFieldDiff > 0L || minuteFieldDiff > 0L;
            if (notFirstDiff && millisecondsFieldDiff == 0L) {
                result.append(" and ");
            } else if (notFirstDiff) {
                result.append(" ");
            }
            result.append(String.format("%ds", secondFieldDiff));
        }
        if (millisecondsFieldDiff > 0L) {
            if (result.length() > 0) {
                result.append(" and ");
            }
            result.append(String.format("%dms", millisecondsFieldDiff));
        }
        return result.toString();
    }
}

