"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const fs = __importStar(require("node:fs/promises"));
const fileExists = async (path) => {
    try {
        await fs.access(path);
        return true;
    }
    catch {
        return false;
    }
};
class Lock extends core_1.Command {
    async run() {
        if (await fileExists('yarn.lock')) {
            this.log('Copying yarn.lock to oclif.lock');
            await fs.copyFile('yarn.lock', 'oclif.lock');
        }
        else {
            throw this.error('yarn.lock does not exist');
        }
    }
    static {
        this.hidden = true;
        this.state = 'deprecated';
        this.summary = 'Copy the yarn.lock to oclif.lock';
        this.deprecationOptions = {
            message: 'oclif.lock is deprecated and will be removed in @oclif/plugin-plugins v5.0.0 and above.',
        };
        this.description = `Using oclif.lock allows your plugins dependencies to be locked to the version specified in the lock file during plugin install.
Once the oclif.lock file is created you can include it your npm package by adding it to the files property of your package.json. We do not recommend committing the oclif.lock file to git.

PLEASE NOTE: the oclif.lock will only work for @oclif/plugin-plugins v3.4.0 and above. It will NOT be supported in v5.0.0 and above.`;
    }
}
exports.default = Lock;
