/*
 * MS SQL Unicode Definitions
 *
 * Copyright (C) 2017 Daniel Lehman
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __SQLUCODE_H
#define __SQLUCODE_H

#include <sqlext.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SQL_WCHAR             (-8)
#define SQL_C_WCHAR           SQL_WCHAR
#define SQL_WVARCHAR          (-9)
#define SQL_WLONGVARCHAR      (-10)

#ifndef WINE_NO_UNICODE_MACROS
# ifdef UNICODE
#  define SQL_C_TCHAR         SQL_C_WCHAR
# else
#  define SQL_C_TCHAR         SQL_C_CHAR
# endif
#endif

SQLRETURN WINAPI SQLBrowseConnectW(SQLHDBC,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLSMALLINT*);

SQLRETURN WINAPI SQLColAttributeW(SQLHSTMT,SQLUSMALLINT,SQLUSMALLINT,SQLPOINTER,SQLSMALLINT,SQLSMALLINT*,SQLLEN*);

SQLRETURN WINAPI SQLColAttributesW(SQLHSTMT,SQLUSMALLINT,SQLUSMALLINT,SQLPOINTER,SQLSMALLINT,SQLSMALLINT*,SQLLEN*);

SQLRETURN WINAPI SQLColumnPrivilegesW(SQLHSTMT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,
                                      SQLWCHAR*,SQLSMALLINT);

SQLRETURN WINAPI SQLColumnsW(SQLHSTMT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,
                             SQLSMALLINT);

SQLRETURN WINAPI SQLConnectW(SQLHDBC,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT);

SQLRETURN WINAPI SQLDataSourcesW(SQLHENV,SQLUSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLSMALLINT*,SQLWCHAR*,SQLSMALLINT,
                                 SQLSMALLINT*);

SQLRETURN WINAPI SQLDescribeColW(SQLHSTMT,SQLUSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLSMALLINT*,SQLSMALLINT*,SQLULEN*,
                                 SQLSMALLINT*,SQLSMALLINT*);

SQLRETURN WINAPI SQLDriverConnectW(SQLHDBC,SQLHWND,WCHAR*,SQLSMALLINT,WCHAR*,SQLSMALLINT,SQLSMALLINT*,SQLUSMALLINT);

SQLRETURN WINAPI SQLDriversW(SQLHENV,SQLUSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLSMALLINT*,SQLWCHAR*,SQLSMALLINT,
                             SQLSMALLINT*);

SQLRETURN WINAPI SQLErrorW(SQLHENV,SQLHDBC,SQLHSTMT,SQLWCHAR*,SQLINTEGER*,SQLWCHAR*,SQLSMALLINT,SQLSMALLINT*);

SQLRETURN WINAPI SQLExecDirectW(SQLHSTMT,SQLWCHAR*,SQLINTEGER);

SQLRETURN WINAPI SQLForeignKeysW(SQLHSTMT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,
                                 SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT);

SQLRETURN WINAPI SQLGetConnectAttrW(SQLHDBC,SQLINTEGER,SQLPOINTER,SQLINTEGER,SQLINTEGER*);

SQLRETURN WINAPI SQLGetConnectOptionW(SQLHDBC,SQLUSMALLINT,SQLPOINTER);

SQLRETURN WINAPI SQLGetCursorNameW(SQLHSTMT,SQLWCHAR*,SQLSMALLINT,SQLSMALLINT*);

SQLRETURN WINAPI SQLGetDescFieldW(SQLHDESC,SQLSMALLINT,SQLSMALLINT,SQLPOINTER,SQLINTEGER,SQLINTEGER*);

SQLRETURN WINAPI SQLGetDescRecW(SQLHDESC,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLSMALLINT*,SQLSMALLINT*,SQLSMALLINT*,
                                SQLLEN*,SQLSMALLINT*,SQLSMALLINT*,SQLSMALLINT*);

SQLRETURN WINAPI SQLGetDiagFieldW(SQLSMALLINT,SQLHANDLE,SQLSMALLINT,SQLSMALLINT,SQLPOINTER,SQLSMALLINT,SQLSMALLINT*);

SQLRETURN WINAPI SQLGetDiagRecW(SQLSMALLINT,SQLHANDLE,SQLSMALLINT,SQLWCHAR*,SQLINTEGER*,SQLWCHAR*,SQLSMALLINT,
                                SQLSMALLINT*);

SQLRETURN WINAPI SQLGetInfoW(SQLHDBC,SQLUSMALLINT,SQLPOINTER,SQLSMALLINT,SQLSMALLINT*);

SQLRETURN WINAPI SQLGetStmtAttrW(SQLHSTMT,SQLINTEGER,SQLPOINTER,SQLINTEGER,SQLINTEGER*);

SQLRETURN WINAPI SQLGetTypeInfoW(SQLHSTMT,SQLSMALLINT);

SQLRETURN WINAPI SQLNativeSqlW(SQLHDBC,SQLWCHAR*,SQLINTEGER,SQLWCHAR*,SQLINTEGER,SQLINTEGER*);

SQLRETURN WINAPI SQLPrepareW(SQLHSTMT,SQLWCHAR*,SQLINTEGER);

SQLRETURN WINAPI SQLPrimaryKeysW(SQLHSTMT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT);

SQLRETURN WINAPI SQLProcedureColumnsW(SQLHSTMT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,
                                      SQLWCHAR*,SQLSMALLINT);

SQLRETURN WINAPI SQLProceduresW(SQLHSTMT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT);

SQLRETURN WINAPI SQLSetConnectAttrW(SQLHDBC,SQLINTEGER,SQLPOINTER,SQLINTEGER);

SQLRETURN WINAPI SQLSetConnectOptionW(SQLHDBC,SQLUSMALLINT,SQLULEN);

SQLRETURN WINAPI SQLSetCursorNameW(SQLHSTMT,SQLWCHAR*,SQLSMALLINT);

SQLRETURN WINAPI SQLSetDescFieldW(SQLHDESC,SQLSMALLINT,SQLSMALLINT,SQLPOINTER,SQLINTEGER);

SQLRETURN WINAPI SQLSetStmtAttrW(SQLHSTMT,SQLINTEGER,SQLPOINTER,SQLINTEGER);

SQLRETURN WINAPI SQLSpecialColumnsW(SQLHSTMT,SQLUSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,
                                    SQLSMALLINT,SQLUSMALLINT,SQLUSMALLINT);

SQLRETURN WINAPI SQLStatisticsW(SQLHSTMT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,
                                SQLUSMALLINT,SQLUSMALLINT);

SQLRETURN WINAPI SQLTablePrivilegesW(SQLHSTMT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT);

SQLRETURN WINAPI SQLTablesW(SQLHSTMT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,SQLSMALLINT,SQLWCHAR*,
                            SQLSMALLINT);

#ifdef __cplusplus
}
#endif

#endif
