/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freeplane.core.ui.components.JComboBoxFactory;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.FormattedFormula;
import org.freeplane.features.format.FormattedObject;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.format.PatternFormat;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.attribute.AttributeTable;
import org.freeplane.view.swing.map.attribute.AttributeView;

public class AttributePanelManager {
    private final JPanel tablePanel;
    private ModeController modeController;
    private int axis = 1;

    public AttributePanelManager(ModeController modeController) {
        this.modeController = modeController;
        this.tablePanel = new JPanel();
        this.tablePanel.setMinimumSize(new Dimension(0, 0));
        this.tablePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, this.axis));
        TableCreator tableCreator = new TableCreator();
        MapController mapController = modeController.getMapController();
        mapController.addNodeSelectionListener(tableCreator);
        mapController.addUINodeChangeListener(tableCreator);
    }

    public JPanel getTablePanel() {
        return this.tablePanel;
    }

    private class TableCreator
    implements INodeSelectionListener,
    INodeChangeListener,
    HierarchyListener {
        private AttributeView attributeView;
        private JComboBox formatChooser;

        public TableCreator() {
            AttributePanelManager.this.tablePanel.addHierarchyListener(this);
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) != 0L) {
                if (AttributePanelManager.this.tablePanel.isShowing()) {
                    this.onSelect(Controller.getCurrentController().getSelection().getSelected());
                } else {
                    this.removeOldView();
                }
            }
        }

        @Override
        public void onDeselect(NodeModel node) {
            if (AttributePanelManager.this.tablePanel.isShowing()) {
                this.removeOldView();
            }
        }

        private void removeOldView() {
            if (this.attributeView != null) {
                AttributePanelManager.this.tablePanel.removeAll();
                AttributePanelManager.this.tablePanel.revalidate();
                AttributePanelManager.this.tablePanel.repaint();
                this.attributeView.viewRemoved();
                this.attributeView = null;
            }
        }

        @Override
        public void onSelect(NodeModel node) {
            if (!AttributePanelManager.this.tablePanel.isShowing()) {
                return;
            }
            this.removeOldView();
            MainView mainView = this.getSelectedMainView();
            if (mainView == null) {
                return;
            }
            NodeView nodeView = this.getNodeViewSafely(mainView, node);
            if (nodeView == null) {
                return;
            }
            this.createNewAttributeView(nodeView);
            this.createButtonPanel();
            this.finalizeTablePanelLayout();
        }

        private MainView getSelectedMainView() {
            return (MainView)Controller.getCurrentController().getMapViewManager().getSelectedComponent();
        }

        private NodeView getNodeViewSafely(MainView mainView, NodeModel node) {
            AttributeController.getController(AttributePanelManager.this.modeController).createAttributeTableModel(node);
            NodeView nodeView = mainView.getNodeView();
            if (nodeView == null) {
                LogUtils.severe(new RuntimeException("Node view null for mainView" + String.valueOf(mainView) + " and node " + String.valueOf(node)));
                return null;
            }
            return nodeView;
        }

        private void createNewAttributeView(NodeView nodeView) {
            this.attributeView = new AttributeView(nodeView, false);
        }

        private void createButtonPanel() {
            Box buttonBox = new Box(AttributePanelManager.this.axis);
            buttonBox.setAlignmentX(0.0f);
            AttributePanelManager.this.tablePanel.add(buttonBox);
            Dimension btnSize = new Dimension();
            this.addNewAttributeButton(buttonBox, btnSize);
            this.addOptimalWidthButton(buttonBox, btnSize);
            this.addFormatChooser(buttonBox, btnSize);
            this.normalizeButtonSizes(buttonBox, btnSize);
            this.setupFormatChooserListeners();
        }

        private void addNewAttributeButton(Box buttonBox, Dimension btnSize) {
            JButton newAttributeButton = new JButton(TextUtils.getText("attributes_popup_new"));
            newAttributeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!AttributePanelManager.this.modeController.isEditingLocked()) {
                        TableCreator.this.attributeView.addRow();
                    }
                }
            });
            this.increaseSize(btnSize, newAttributeButton);
            buttonBox.add(newAttributeButton);
        }

        private void addOptimalWidthButton(Box buttonBox, Dimension btnSize) {
            JButton optimalWidthButton = new JButton(TextUtils.getText("attributes_popup_optimal_width"));
            optimalWidthButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!AttributePanelManager.this.modeController.isEditingLocked()) {
                        TableCreator.this.attributeView.setOptimalColumnWidths();
                    }
                }
            });
            this.increaseSize(btnSize, optimalWidthButton);
            buttonBox.add(optimalWidthButton);
        }

        private void normalizeButtonSizes(Box buttonBox, Dimension btnSize) {
            for (int i = 0; i < buttonBox.getComponentCount(); ++i) {
                buttonBox.getComponent(i).setMaximumSize(btnSize);
            }
        }

        private void finalizeTablePanelLayout() {
            AttributePanelManager.this.tablePanel.add(Box.createVerticalStrut(5));
            JComponent c = this.attributeView.getContainer();
            this.attributeView.update();
            c.setAlignmentX(0.0f);
            AttributePanelManager.this.tablePanel.add(c);
            AttributePanelManager.this.tablePanel.add(Box.createGlue());
            AttributePanelManager.this.tablePanel.revalidate();
            AttributePanelManager.this.tablePanel.repaint();
        }

        private void addFormatChooser(Box buttonBox, Dimension btnSize) {
            this.formatChooser = this.createFormatChooser();
            this.formatChooser.setEnabled(false);
            this.increaseSize(btnSize, this.formatChooser);
            buttonBox.add(this.formatChooser);
        }

        private JComboBox createFormatChooser() {
            ArrayList<PatternFormat> formats = FormatController.getController().getAllFormats();
            Vector<PatternFormat> items = new Vector<PatternFormat>(formats);
            for (int i = items.size() - 1; i >= 0; --i) {
                PatternFormat item = items.get(i);
                if (!item.getType().equals("identity") || item.getType().endsWith("NO_FORMAT")) continue;
                items.remove(i);
            }
            JComboBox<PatternFormat> formatChooser = JComboBoxFactory.create(items);
            formatChooser.setEditable(true);
            formatChooser.setSelectedItem(null);
            String NODE_FORMAT = "OptionPanel.nodeformat";
            formatChooser.setToolTipText(TextUtils.getRawText("OptionPanel.nodeformat.tooltip"));
            formatChooser.setAlignmentX(0.0f);
            formatChooser.setBorder(new TitledBorder(TextUtils.getText("value_format")));
            return formatChooser;
        }

        private void increaseSize(Dimension btnSize, JComponent comp) {
            Dimension preferredSize = comp.getPreferredSize();
            btnSize.width = Math.max(btnSize.width, preferredSize.width);
            btnSize.height = Math.max(btnSize.height, preferredSize.height);
        }

        private void setupFormatChooserListeners() {
            this.formatChooser.addItemListener(new ItemListener(){
                boolean handlingEvent = false;

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (this.handlingEvent || !TableCreator.this.formatChooser.isEnabled() || e.getStateChange() != 1) {
                        return;
                    }
                    this.handlingEvent = true;
                    PatternFormat newFormat = this.toPatternFormat(e.getItem());
                    AttributeTable table = TableCreator.this.attributeView.getAttributeTable();
                    if (table.getSelectedColumn() == 1 && table.getSelectedRow() != -1) {
                        Object value = table.getValueAt(table.getSelectedRow(), table.getSelectedColumn());
                        try {
                            Object newValue = this.formatValue(newFormat, table, value);
                            if (newValue != null) {
                                table.setValueAt(newValue, table.getSelectedRow(), table.getSelectedColumn());
                            }
                        }
                        catch (Exception e2) {
                            Controller.getCurrentController().getViewController().out("Pattern is not applicable: " + e2.getMessage());
                            LogUtils.warn("pattern is not applicable", e2);
                        }
                    }
                    this.handlingEvent = false;
                }

                public PatternFormat toPatternFormat(Object value) {
                    if (value instanceof PatternFormat) {
                        return (PatternFormat)value;
                    }
                    PatternFormat patternFormat = PatternFormat.guessPatternFormat(value.toString());
                    return patternFormat == null ? PatternFormat.getIdentityPatternFormat() : patternFormat;
                }

                private Object formatValue(PatternFormat newFormat, AttributeTable table, Object objectToBeFormatted) {
                    Object actualObject;
                    if (TableCreator.this.formatChooser.getSelectedItem() == null) {
                        return null;
                    }
                    if (objectToBeFormatted instanceof IFormattedObject && (actualObject = ((IFormattedObject)objectToBeFormatted).getObject()) != objectToBeFormatted) {
                        return this.formatValue(newFormat, table, actualObject);
                    }
                    if (newFormat == PatternFormat.getIdentityPatternFormat()) {
                        return this.makeFormattedObjectForIdentityFormat(objectToBeFormatted);
                    }
                    if (objectToBeFormatted instanceof String && ((String)objectToBeFormatted).startsWith("=")) {
                        return new FormattedFormula((String)objectToBeFormatted, newFormat.getPattern());
                    }
                    return newFormat.formatObject(objectToBeFormatted);
                }

                private FormattedObject makeFormattedObjectForIdentityFormat(Object objectToBeFormatted) {
                    return new FormattedObject((Object)String.valueOf(objectToBeFormatted), "NO_FORMAT");
                }
            });
            this.attributeView.addTableSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (AttributePanelManager.this.tablePanel.isShowing() && TableCreator.this.attributeView != null && !event.getValueIsAdjusting()) {
                        TableCreator.this.setSelectedFormatItem();
                    }
                }
            });
        }

        private void setSelectedFormatItem() {
            AttributeTable table = this.attributeView.getAttributeTable();
            int selectedColumn = table.getSelectedColumn();
            int selectedRow = table.getSelectedRow();
            if (selectedColumn == 1 && selectedRow >= 0 && selectedRow < table.getRowCount()) {
                this.formatChooser.setEnabled(true);
                Object value = table.getValueAt(selectedRow, selectedColumn);
                if (value instanceof IFormattedObject) {
                    String format = ((IFormattedObject)value).getPattern();
                    this.formatChooser.setSelectedItem(PatternFormat.guessPatternFormat(format));
                } else {
                    this.formatChooser.setSelectedItem(null);
                }
            } else {
                this.formatChooser.setEnabled(false);
            }
        }

        @Override
        public void nodeChanged(NodeChangeEvent event) {
            if (!AttributePanelManager.this.tablePanel.isShowing()) {
                return;
            }
            if (this.attributeView != null && event.getProperty().equals(NodeAttributeTableModel.class)) {
                this.setSelectedFormatItem();
            }
        }
    }
}

