/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class LimitedBufferSlicePool {
    private static final AtomicIntegerFieldUpdater regionUpdater = AtomicIntegerFieldUpdater.newUpdater(LimitedBufferSlicePool.class, "regionsUsed");
    private final Queue<Slice> sliceQueue = new ConcurrentLinkedQueue<Slice>();
    private final ByteBufAllocator allocator;
    private final int bufferSize;
    private final int buffersPerRegion;
    private final int maxRegions;
    private volatile int regionsUsed;

    public LimitedBufferSlicePool(ByteBufAllocator allocator, int bufferSize, int maxRegionSize, int maxRegions) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than zero");
        }
        if (maxRegionSize < bufferSize) {
            throw new IllegalArgumentException("Maximum region size must be greater than or equal to the buffer size");
        }
        this.buffersPerRegion = maxRegionSize / bufferSize;
        this.bufferSize = bufferSize;
        this.allocator = allocator;
        this.maxRegions = maxRegions;
    }

    public LimitedBufferSlicePool(ByteBufAllocator allocator, int bufferSize, int maxRegionSize) {
        this(allocator, bufferSize, maxRegionSize, 0);
    }

    public LimitedBufferSlicePool(int bufferSize, int maxRegionSize) {
        this(ByteBufAllocator.DEFAULT, bufferSize, maxRegionSize);
    }

    public PooledByteBuffer allocate() {
        Queue<Slice> sliceQueue = this.sliceQueue;
        Slice slice = sliceQueue.poll();
        if (slice == null && (this.maxRegions <= 0 || regionUpdater.getAndIncrement(this) < this.maxRegions)) {
            int bufferSize = this.bufferSize;
            int buffersPerRegion = this.buffersPerRegion;
            ByteBuf region = this.allocator.buffer(buffersPerRegion * bufferSize);
            int idx = bufferSize;
            for (int i = 1; i < buffersPerRegion; ++i) {
                sliceQueue.add(new Slice(region, idx, bufferSize));
                idx += bufferSize;
            }
            Slice newSlice = new Slice(region, 0, bufferSize);
            return new PooledByteBuffer(newSlice, newSlice.slice(), sliceQueue);
        }
        if (slice == null) {
            return null;
        }
        return new PooledByteBuffer(slice, slice.slice(), sliceQueue);
    }

    public boolean canAllocate(int slices) {
        if (this.regionsUsed < this.maxRegions) {
            return true;
        }
        if (this.sliceQueue.isEmpty()) {
            return false;
        }
        Iterator iterator = this.sliceQueue.iterator();
        for (int i = 0; i < slices; ++i) {
            if (!iterator.hasNext()) {
                return false;
            }
            try {
                iterator.next();
                continue;
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }
        return true;
    }

    private static final class Slice {
        private final ByteBuf parent;
        private final int start;
        private final int size;

        private Slice(ByteBuf parent, int start, int size) {
            this.parent = parent;
            this.start = start;
            this.size = size;
        }

        ByteBuf slice() {
            return this.parent.slice(this.start, this.start + this.size);
        }
    }

    public static final class PooledByteBuffer {
        private final Slice region;
        private final Queue<Slice> slices;
        volatile ByteBuf buffer;
        private static final AtomicReferenceFieldUpdater<PooledByteBuffer, ByteBuf> bufferUpdater = AtomicReferenceFieldUpdater.newUpdater(PooledByteBuffer.class, ByteBuf.class, "buffer");

        private PooledByteBuffer(Slice region, ByteBuf buffer, Queue<Slice> slices) {
            this.region = region;
            this.buffer = buffer;
            this.slices = slices;
        }

        public void free() {
            if (bufferUpdater.getAndSet(this, null) != null) {
                this.slices.add(this.region);
            }
        }

        public ByteBuf getBuffer() {
            ByteBuf buffer = this.buffer;
            if (buffer == null) {
                throw new IllegalStateException();
            }
            return buffer;
        }

        public String toString() {
            return "Pooled buffer " + String.valueOf(this.buffer);
        }
    }
}

