/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.models.internal.util.AnnotationAttributeTypeHelper;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.ValueTypeDescriptor;

public class AnnotationDescriptorBuilding {
    public static <A extends Annotation> List<AttributeDescriptor<?>> extractAttributeDescriptors(Class<A> annotationType) {
        Method[] methods = annotationType.getDeclaredMethods();
        ArrayList attributeDescriptors = new ArrayList(methods.length);
        for (Method method : methods) {
            attributeDescriptors.add(AnnotationDescriptorBuilding.createAttributeDescriptor(annotationType, method));
        }
        return attributeDescriptors;
    }

    private static <X, A extends Annotation> AttributeDescriptor<X> createAttributeDescriptor(Class<A> annotationType, Method method) {
        Class<?> attributeType = method.getReturnType();
        ValueTypeDescriptor typeDescriptor = AnnotationAttributeTypeHelper.resolveTypeDescriptor(attributeType);
        return typeDescriptor.createAttributeDescriptor(annotationType, method.getName());
    }
}

