/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public final class EntityKey
implements Serializable {
    private final Object identifier;
    private final int hashCode;
    private final EntityPersister persister;

    public EntityKey(@Nullable Object id, EntityPersister persister) {
        this.persister = persister;
        if (id == null) {
            throw new AssertionFailure("null identifier (" + persister.getEntityName() + ")");
        }
        this.identifier = id;
        this.hashCode = this.generateHashCode();
    }

    private int generateHashCode() {
        int result = 17;
        String rootEntityName = this.persister.getRootEntityName();
        result = 37 * result + rootEntityName.hashCode();
        Type identifierType = this.persister.getIdentifierType().getTypeForEqualsHashCode();
        result = 37 * result + (identifierType == null ? this.identifier.hashCode() : identifierType.getHashCode(this.identifier, this.persister.getFactory()));
        return result;
    }

    public boolean isBatchLoadable(LoadQueryInfluencers influencers) {
        return influencers.effectivelyBatchLoadable(this.persister);
    }

    public Object getIdentifierValue() {
        return this.identifier;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public String getEntityName() {
        return this.persister.getEntityName();
    }

    public EntityPersister getPersister() {
        return this.persister;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || EntityKey.class != other.getClass()) {
            return false;
        }
        EntityKey otherKey = (EntityKey)other;
        return this.samePersistentType(otherKey) && this.sameIdentifier(otherKey);
    }

    private boolean sameIdentifier(EntityKey otherKey) {
        Type identifierType;
        return this.identifier == otherKey.identifier || (identifierType = this.persister.getIdentifierType().getTypeForEqualsHashCode()) == null && this.identifier.equals(otherKey.identifier) || identifierType != null && identifierType.isEqual(otherKey.identifier, this.identifier, this.persister.getFactory());
    }

    private boolean samePersistentType(EntityKey otherKey) {
        return otherKey.persister == this.persister || otherKey.persister.getRootEntityName().equals(this.persister.getRootEntityName());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "EntityKey" + MessageHelper.infoString(this.persister, this.identifier, this.persister.getFactory());
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.identifier);
        oos.writeObject(this.persister.getEntityName());
    }

    public static EntityKey deserialize(ObjectInputStream ois, SessionFactoryImplementor sessionFactory) throws IOException, ClassNotFoundException {
        Object id = ois.readObject();
        String entityName = (String)ois.readObject();
        EntityPersister entityPersister = sessionFactory.getMappingMetamodel().getEntityDescriptor(entityName);
        return new EntityKey(id, entityPersister);
    }
}

