/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.nl;

import java.util.Vector;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.UninitializedObjectException;

public final class NVTokens {
    public static final int TKN_NONE = 0;
    public static final int TKN_LPAREN = 1;
    public static final int TKN_RPAREN = 2;
    public static final int TKN_COMMA = 3;
    public static final int TKN_EQUAL = 4;
    public static final int TKN_LITERAL = 8;
    public static final int TKN_EOS = 9;
    private static final char TKN_LPAREN_VALUE = '(';
    private static final char TKN_RPAREN_VALUE = ')';
    private static final char TKN_COMMA_VALUE = ',';
    private static final char TKN_EQUAL_VALUE = '=';
    private static final char TKN_BKSLASH_VALUE = '\\';
    private static final char TKN_DQUOTE_VALUE = '\"';
    private static final char TKN_SQUOTE_VALUE = '\'';
    private static final char TKN_EOS_VALUE = '%';
    private static final char TKN_SPC_VALUE = ' ';
    private static final char TKN_TAB_VALUE = '\t';
    private static final char TKN_LF_VALUE = '\n';
    private static final char TKN_CR_VALUE = '\r';
    private Vector _tkType = null;
    private Vector _tkValue = null;
    private int _numTokens = 0;
    private int _tkPos = 0;

    private static boolean _isWhiteSpace(char it) {
        return it == ' ' || it == '\t' || it == '\n' || it == '\r';
    }

    private static String _trimWhiteSpace(String it) {
        int start;
        int length = it.length();
        int end = length;
        for (start = 0; start < length && NVTokens._isWhiteSpace(it.charAt(start)); ++start) {
        }
        while (start < end && NVTokens._isWhiteSpace(it.charAt(end - 1))) {
            --end;
        }
        return it.substring(start, end);
    }

    public boolean parseTokens(String nvString) {
        this._numTokens = 0;
        this._tkPos = 0;
        this._tkType = new Vector(25, 25);
        this._tkValue = new Vector(25, 25);
        int len = nvString.length();
        boolean eql_seen = false;
        char[] input = nvString.toCharArray();
        int pos = 0;
        block6: while (pos < len) {
            while (pos < len && NVTokens._isWhiteSpace(input[pos])) {
                ++pos;
            }
            if (pos >= len) continue;
            switch (input[pos]) {
                case '(': {
                    eql_seen = false;
                    this._addToken(1, '(');
                    ++pos;
                    continue block6;
                }
                case '=': {
                    eql_seen = true;
                    this._addToken(4, '=');
                    ++pos;
                    continue block6;
                }
                case ')': {
                    eql_seen = false;
                    this._addToken(2, ')');
                    ++pos;
                    continue block6;
                }
                case ',': {
                    eql_seen = false;
                    this._addToken(3, ',');
                    ++pos;
                    continue block6;
                }
            }
            int startPos = pos;
            int endPos = -1;
            boolean quoted_str = false;
            char quote_char = '\"';
            if (input[pos] == '\'' || input[pos] == '\"') {
                quoted_str = true;
                quote_char = input[pos];
                ++pos;
            }
            while (pos < len) {
                if (input[pos] == '\\') {
                    pos += 2;
                    continue;
                }
                if (quoted_str) {
                    if (input[pos] == quote_char) {
                        endPos = ++pos;
                        break;
                    }
                } else if (input[pos] == '(' || input[pos] == ')' || input[pos] == ',' && !eql_seen || input[pos] == '=' && !eql_seen) {
                    endPos = pos;
                    break;
                }
                ++pos;
            }
            if (endPos == -1) {
                endPos = pos;
            }
            this._addToken(8, NVTokens._trimWhiteSpace(nvString.substring(startPos, endPos)));
        }
        this._addToken(9, '%');
        return true;
    }

    public int getToken() throws NLException {
        if (this._tkType == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos < this._numTokens) {
            return (Integer)this._tkType.elementAt(this._tkPos);
        }
        throw new NLException("NoLiterals-04610", "");
    }

    public int popToken() throws UninitializedObjectException, NLException {
        int token = 0;
        if (this._tkType == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos >= this._numTokens) {
            throw new NLException("NoLiterals-04610", "");
        }
        token = (Integer)this._tkType.elementAt(this._tkPos++);
        return token;
    }

    public String getLiteral() throws NLException {
        String theLiteral = null;
        if (this._tkValue == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos >= this._numTokens) {
            throw new NLException("NoLiterals-04610", "");
        }
        theLiteral = (String)this._tkValue.elementAt(this._tkPos);
        return theLiteral;
    }

    public String popLiteral() throws NLException {
        String theLiteral = null;
        if (this._tkValue == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos >= this._numTokens) {
            throw new NLException("NoLiterals-04610", "");
        }
        theLiteral = (String)this._tkValue.elementAt(this._tkPos++);
        return theLiteral;
    }

    public void eatToken() {
        if (this._tkPos < this._numTokens) {
            ++this._tkPos;
        }
    }

    public String toString() {
        if (this._tkType == null) {
            return "*NO TOKENS*";
        }
        Object out = "Tokens";
        for (int i = 0; i < this._numTokens; ++i) {
            out = (String)out + " : " + this._tkValue.elementAt(i);
        }
        return out;
    }

    public void println() {
        System.out.println(this.toString());
    }

    private void _addToken(int tk, char tk_char) {
        this._addToken(tk, String.valueOf(tk_char));
    }

    private void _addToken(int tk, String tk_val) {
        this._tkType.addElement(new Integer(tk));
        this._tkValue.addElement(tk_val);
        ++this._numTokens;
    }
}

