/*
 * Decompiled with CFR 0.152.
 */
package com.github.jgonian.ipmath;

import com.github.jgonian.ipmath.AbstractRange;
import com.github.jgonian.ipmath.Asn;
import com.github.jgonian.ipmath.InternetResourceRange;
import com.github.jgonian.ipmath.Validate;

public final class AsnRange
extends AbstractRange<Asn, AsnRange>
implements InternetResourceRange<Asn, AsnRange> {
    protected AsnRange(Asn start, Asn end) {
        super(start, end);
    }

    @Override
    protected AsnRange newInstance(Asn start, Asn end) {
        return new AsnRange(start, end);
    }

    public static AsnRangeBuilder from(Long from) {
        return AsnRange.from(Asn.of(from));
    }

    public static AsnRangeBuilder from(Asn from) {
        return new AsnRangeBuilder(from);
    }

    public static AsnRangeBuilder from(String from) {
        return new AsnRangeBuilder(Asn.parse(from));
    }

    public static AsnRange parse(String text) {
        int idx = text.indexOf(45);
        Validate.isTrue(idx != -1, "Invalid range of ASNs: '" + text + "'");
        Asn start = Asn.parse(text.substring(0, idx));
        Asn end = Asn.parse(text.substring(idx + 1));
        return new AsnRange(start, end);
    }

    public boolean containsOnly16BitAsns() {
        return ((Asn)this.end()).is16Bit();
    }

    public boolean containsOnly32BitAsns() {
        return ((Asn)this.start()).is32Bit();
    }

    @Override
    public String toString() {
        return this.start() + "-" + this.end();
    }

    public Long size() {
        return ((Asn)this.end()).value() - ((Asn)this.start()).value() + 1L;
    }

    public static class AsnRangeBuilder
    extends AbstractRange.AbstractRangeBuilder<Asn, AsnRange> {
        private final Asn from;

        protected AsnRangeBuilder(Asn from) {
            this.from = from;
        }

        @Override
        public AsnRange to(Long end) {
            return this.to(Asn.of(end));
        }

        @Override
        public AsnRange to(String end) {
            return this.to(Asn.parse(end));
        }

        @Override
        public AsnRange to(Asn to) {
            return new AsnRange(this.from, to);
        }
    }
}

