/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GarbageCollectorTotal
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GarbageCollectorTotal> {
    @Nullable
    private final Long collectionCount;
    @Nullable
    private final Time collectionTime;
    @Nullable
    private final Long collectionTimeInMillis;
    public static final JsonpDeserializer<GarbageCollectorTotal> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GarbageCollectorTotal::setupGarbageCollectorTotalDeserializer);

    private GarbageCollectorTotal(Builder builder) {
        this.collectionCount = builder.collectionCount;
        this.collectionTime = builder.collectionTime;
        this.collectionTimeInMillis = builder.collectionTimeInMillis;
    }

    public static GarbageCollectorTotal of(Function<Builder, ObjectBuilder<GarbageCollectorTotal>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long collectionCount() {
        return this.collectionCount;
    }

    @Nullable
    public final Time collectionTime() {
        return this.collectionTime;
    }

    @Nullable
    public final Long collectionTimeInMillis() {
        return this.collectionTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.collectionCount != null) {
            generator.writeKey("collection_count");
            generator.write(this.collectionCount.longValue());
        }
        if (this.collectionTime != null) {
            generator.writeKey("collection_time");
            this.collectionTime.serialize(generator, mapper);
        }
        if (this.collectionTimeInMillis != null) {
            generator.writeKey("collection_time_in_millis");
            generator.write(this.collectionTimeInMillis.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGarbageCollectorTotalDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::collectionCount, JsonpDeserializer.longDeserializer(), "collection_count");
        op.add(Builder::collectionTime, Time._DESERIALIZER, "collection_time");
        op.add(Builder::collectionTimeInMillis, JsonpDeserializer.longDeserializer(), "collection_time_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.collectionCount);
        result = 31 * result + Objects.hashCode(this.collectionTime);
        result = 31 * result + Objects.hashCode(this.collectionTimeInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GarbageCollectorTotal other = (GarbageCollectorTotal)o;
        return Objects.equals(this.collectionCount, other.collectionCount) && Objects.equals(this.collectionTime, other.collectionTime) && Objects.equals(this.collectionTimeInMillis, other.collectionTimeInMillis);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GarbageCollectorTotal> {
        @Nullable
        private Long collectionCount;
        @Nullable
        private Time collectionTime;
        @Nullable
        private Long collectionTimeInMillis;

        public Builder() {
        }

        private Builder(GarbageCollectorTotal o) {
            this.collectionCount = o.collectionCount;
            this.collectionTime = o.collectionTime;
            this.collectionTimeInMillis = o.collectionTimeInMillis;
        }

        private Builder(Builder o) {
            this.collectionCount = o.collectionCount;
            this.collectionTime = o.collectionTime;
            this.collectionTimeInMillis = o.collectionTimeInMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder collectionCount(@Nullable Long value) {
            this.collectionCount = value;
            return this;
        }

        @Nonnull
        public final Builder collectionTime(@Nullable Time value) {
            this.collectionTime = value;
            return this;
        }

        @Nonnull
        public final Builder collectionTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.collectionTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder collectionTimeInMillis(@Nullable Long value) {
            this.collectionTimeInMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public GarbageCollectorTotal build() {
            this._checkSingleUse();
            return new GarbageCollectorTotal(this);
        }
    }
}

