#ifndef TIMING_PLACE_LOOKUP_H
#define TIMING_PLACE_LOOKUP_H
#include "place_delay_model.h"

std::unique_ptr<PlaceDelayModel> compute_place_delay_model(const t_placer_opts& placer_opts,
                                                           const t_router_opts& router_opts,
                                                           const Netlist<>& net_list,
                                                           t_det_routing_arch* det_routing_arch,
                                                           std::vector<t_segment_inf>& segment_inf,
                                                           t_chan_width_dist chan_width_dist,
                                                           const std::vector<t_direct_inf>& directs,
                                                           bool is_flat);

std::vector<int> get_best_classes(enum e_pin_type pintype, t_physical_tile_type_ptr type);

bool directconnect_exists(RRNodeId src_rr_node, RRNodeId sink_rr_node);

#endif
