/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.enterprise;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectSessionContext;
import ca.sqlpower.architect.ArchitectSessionImpl;
import ca.sqlpower.architect.SnapshotCollection;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.enterprise.ArchitectDataSourceCollectionUpdater;
import ca.sqlpower.architect.enterprise.ArchitectNetworkConflictResolver;
import ca.sqlpower.architect.enterprise.ArchitectPersisterSuperConverter;
import ca.sqlpower.architect.enterprise.ArchitectSessionPersister;
import ca.sqlpower.architect.enterprise.DomainCategory;
import ca.sqlpower.architect.enterprise.DomainCategorySnapshot;
import ca.sqlpower.architect.enterprise.SPObjectSnapshotHierarchyListener;
import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.dao.MessageSender;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.SPPersisterListener;
import ca.sqlpower.dao.SPSessionPersister;
import ca.sqlpower.dao.json.SPJSONMessageDecoder;
import ca.sqlpower.dao.json.SPJSONPersister;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.diff.DiffInfo;
import ca.sqlpower.diff.SimpleDiffChunkJSONConverter;
import ca.sqlpower.enterprise.ClientSideSessionUtils;
import ca.sqlpower.enterprise.DataSourceCollectionUpdater;
import ca.sqlpower.enterprise.JSONMessage;
import ca.sqlpower.enterprise.JSONResponseHandler;
import ca.sqlpower.enterprise.ServerInfoProvider;
import ca.sqlpower.enterprise.TransactionInformation;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.enterprise.client.RevisionController;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.enterprise.client.User;
import ca.sqlpower.object.AbstractPoolingSPListener;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPObjectSnapshot;
import ca.sqlpower.object.SPObjectUUIDComparator;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.PlDotIni;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sql.SpecificDataSourceCollection;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.sqlobject.UserDefinedSQLTypeSnapshot;
import ca.sqlpower.swingui.event.SessionLifecycleEvent;
import ca.sqlpower.swingui.event.SessionLifecycleListener;
import ca.sqlpower.util.DefaultUserPrompterFactory;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.olap4j.metadata.Datatype;
import org.springframework.security.AccessDeniedException;

public class ArchitectClientSideSession
extends ArchitectSessionImpl
implements RevisionController {
    private static Logger logger = Logger.getLogger(ArchitectClientSideSession.class);
    private static CookieStore cookieStore = new BasicCookieStore();
    public static final String MONDRIAN_SCHEMA_REL_PATH = "/mondrian";
    private final Preferences prefs = Preferences.userNodeForPackage(ArchitectClientSideSession.class);
    private final ProjectLocation projectLocation;
    private final HttpClient outboundHttpClient;
    private final ArchitectSessionPersister sessionPersister;
    private final SPJSONPersister jsonPersister;
    private final ArchitectNetworkConflictResolver updater;
    private final SPJSONMessageDecoder jsonMessageDecoder;
    private final DataSourceCollectionUpdater dataSourceCollectionUpdater;
    private DataSourceCollection<JDBCDataSource> dataSourceCollection;
    public static Map<String, ArchitectClientSideSession> securitySessions = new HashMap<String, ArchitectClientSideSession>();
    private AbstractPoolingSPListener deletionListener;
    private final ThreadPoolExecutor foregroundThreadExecutor;
    private final boolean useThreadPool;
    private final Set<Thread> foregroundExecutorThread = Collections.synchronizedSet(new HashSet());

    public ArchitectClientSideSession(ArchitectSessionContext context, String name, ProjectLocation projectLocation) throws SQLObjectException {
        this(context, name, projectLocation, false);
    }

    public ArchitectClientSideSession(ArchitectSessionContext context, String name, ProjectLocation projectLocation, boolean useThreadPool) throws SQLObjectException {
        super(context, name, new ArchitectSwingProject());
        this.projectLocation = projectLocation;
        this.useThreadPool = useThreadPool;
        this.foregroundThreadExecutor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = new Thread(r);
                ArchitectClientSideSession.this.foregroundExecutorThread.add(newThread);
                return newThread;
            }
        });
        this.foregroundThreadExecutor.allowCoreThreadTimeOut(false);
        this.dataSourceCollectionUpdater = new ArchitectDataSourceCollectionUpdater(projectLocation);
        this.isEnterpriseSession = true;
        this.setupSnapshots();
        String ddlgClass = this.prefs.get(this.projectLocation.getUUID() + ".ddlg", null);
        if (ddlgClass != null) {
            try {
                DDLGenerator ddlg = (DDLGenerator)Class.forName(ddlgClass, true, ArchitectClientSideSession.class.getClassLoader()).newInstance();
                this.setDDLGenerator(ddlg);
                ddlg.setTargetCatalog(this.prefs.get(this.projectLocation.getUUID() + ".targetCatalog", null));
                ddlg.setTargetSchema(this.prefs.get(this.projectLocation.getUUID() + ".targetSchema", null));
            }
            catch (Exception e) {
                this.createUserPrompter("Cannot load DDL settings due to missing class " + ddlgClass, UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, "OK");
                logger.error((Object)("Cannot find DDL Generator for class " + ddlgClass + ", ddl generator properties are not loaded."));
            }
        }
        this.outboundHttpClient = ClientSideSessionUtils.createHttpClient((SPServerInfo)projectLocation.getServiceInfo(), (CookieStore)cookieStore);
        this.dataSourceCollection = this.getDataSources();
        this.sessionPersister = new ArchitectSessionPersister("inbound-" + projectLocation.getUUID(), (SPObject)this.getWorkspace(), new ArchitectPersisterSuperConverter(this.dataSourceCollection, (SPObject)this.getWorkspace()));
        this.sessionPersister.setWorkspaceContainer(this);
        this.jsonMessageDecoder = new SPJSONMessageDecoder((SPPersister)this.sessionPersister);
        this.updater = new ArchitectNetworkConflictResolver(projectLocation, this.jsonMessageDecoder, ClientSideSessionUtils.createHttpClient((SPServerInfo)projectLocation.getServiceInfo(), (CookieStore)cookieStore), this.outboundHttpClient, this);
        this.jsonPersister = new SPJSONPersister((MessageSender)this.updater);
        this.verifyServerLicense(projectLocation);
    }

    protected void verifyServerLicense(ProjectLocation projectLocation) throws AssertionError {
        try {
            ServerInfoProvider.getServerVersion((String)projectLocation.getServiceInfo().getServerAddress(), (String)String.valueOf(projectLocation.getServiceInfo().getPort()), (String)projectLocation.getServiceInfo().getPath(), (String)projectLocation.getServiceInfo().getUsername(), (String)projectLocation.getServiceInfo().getPassword(), (CookieStore)cookieStore);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Exception encountered while verifying the server license:" + e.getMessage()));
        }
    }

    private void setupSnapshots() {
        this.getTargetDatabase().addSPListener((SPListener)new SPObjectSnapshotHierarchyListener(this));
        final AbstractPoolingSPListener obsolescenceListener = new AbstractPoolingSPListener(false){

            public void childAddedImpl(SPChildEvent e) {
                if (e.getChild() instanceof UserDefinedSQLTypeSnapshot) {
                    UserDefinedSQLTypeSnapshot snapshot = (UserDefinedSQLTypeSnapshot)e.getChild();
                    UserDefinedSQLType systemType = ArchitectClientSideSession.this.findSystemTypeFromSnapshot((SPObjectSnapshot<?>)snapshot);
                    if (systemType == null) {
                        snapshot.setDeleted(true);
                    } else {
                        if (!UserDefinedSQLType.areEqual((UserDefinedSQLType)snapshot.getSPObject(), (UserDefinedSQLType)systemType)) {
                            snapshot.setObsolete(true);
                        }
                        snapshot.setDeleted(false);
                    }
                } else if (e.getChild() instanceof DomainCategorySnapshot) {
                    DomainCategorySnapshot snapshot = (DomainCategorySnapshot)e.getChild();
                    boolean deleted = true;
                    for (DomainCategory category : ArchitectClientSideSession.this.getSystemWorkspace().getDomainCategories()) {
                        if (!category.getUUID().equals(snapshot.getOriginalUUID())) continue;
                        deleted = false;
                        if (DomainCategory.areEqual(snapshot.getSPObject(), category)) continue;
                        snapshot.setObsolete(true);
                        deleted = true;
                    }
                    snapshot.setDeleted(deleted);
                }
            }
        };
        this.getWorkspace().getSnapshotCollection().addSPListener((SPListener)obsolescenceListener);
        this.getWorkspace().addSPListener((SPListener)new AbstractSPListener(){

            public void transactionStarted(TransactionEvent e) {
                obsolescenceListener.transactionStarted(TransactionEvent.createStartTransactionEvent((Object)((Object)ArchitectClientSideSession.this.getWorkspace().getSnapshotCollection()), (String)("Simulated begin: " + e.getMessage())));
            }

            public void transactionEnded(TransactionEvent e) {
                obsolescenceListener.transactionEnded(TransactionEvent.createEndTransactionEvent((Object)((Object)ArchitectClientSideSession.this.getWorkspace().getSnapshotCollection()), (String)("Simulated commit: " + e.getMessage())));
            }

            public void transactionRollback(TransactionEvent e) {
                obsolescenceListener.transactionRollback(TransactionEvent.createRollbackTransactionEvent((Object)((Object)ArchitectClientSideSession.this.getWorkspace().getSnapshotCollection()), (String)("Simulated rollback: " + e.getMessage())));
            }
        });
        if (this.getSystemSession() != null) {
            this.deletionListener = new AbstractPoolingSPListener(){

                protected void childAddedImpl(SPChildEvent e) {
                    if (e.getChild() instanceof DomainCategory) {
                        e.getChild().addSPListener((SPListener)ArchitectClientSideSession.this.deletionListener);
                    } else {
                        for (SPObjectSnapshot snapshot : ArchitectClientSideSession.this.getWorkspace().getSnapshotCollection().getChildren(SPObjectSnapshot.class)) {
                            if (!snapshot.getOriginalUUID().equals(e.getChild().getUUID())) continue;
                            snapshot.setDeleted(false);
                        }
                    }
                }

                protected void childRemovedImpl(SPChildEvent e) {
                    if (e.getChild() instanceof DomainCategory) {
                        e.getChild().removeSPListener((SPListener)ArchitectClientSideSession.this.deletionListener);
                    } else {
                        for (SPObjectSnapshot snapshot : ArchitectClientSideSession.this.getWorkspace().getSnapshotCollection().getChildren(SPObjectSnapshot.class)) {
                            if (!snapshot.getOriginalUUID().equals(e.getChild().getUUID())) continue;
                            snapshot.setDeleted(true);
                        }
                    }
                }
            };
            this.getSystemWorkspace().addSPListener((SPListener)this.deletionListener);
            for (DomainCategory cat : this.getSystemWorkspace().getChildren(DomainCategory.class)) {
                cat.addSPListener((SPListener)this.deletionListener);
            }
        }
    }

    public static Map<String, ArchitectClientSideSession> getSecuritySessions() {
        return securitySessions;
    }

    @Override
    public boolean close() {
        if (this.getDDLGenerator() != null) {
            if (this.getDDLGenerator().getTargetCatalog() != null) {
                this.prefs.put(this.projectLocation.getUUID() + ".targetCatalog", this.getDDLGenerator().getTargetCatalog());
            }
            if (this.getDDLGenerator().getTargetSchema() != null) {
                this.prefs.put(this.projectLocation.getUUID() + ".targetSchema", this.getDDLGenerator().getTargetSchema());
            }
            this.prefs.put(this.projectLocation.getUUID() + ".ddlg", this.getDDLGenerator().getClass().getName());
        }
        this.updater.interrupt();
        this.outboundHttpClient.getConnectionManager().shutdown();
        if (this.dataSourceCollection != null) {
            this.dataSourceCollectionUpdater.detach(this.dataSourceCollection);
        }
        this.getSystemWorkspace().removeSPListener((SPListener)this.deletionListener);
        for (DomainCategory cat : this.getSystemWorkspace().getChildren(DomainCategory.class)) {
            cat.removeSPListener((SPListener)this.deletionListener);
        }
        return super.close();
    }

    @Override
    public DataSourceCollection<JDBCDataSource> getDataSources() {
        if (this.dataSourceCollection == null) {
            this.dataSourceCollection = this.getDataSourcesFromServer();
            this.dataSourceCollectionUpdater.attach(this.dataSourceCollection);
        }
        return this.dataSourceCollection;
    }

    private DataSourceCollection<JDBCDataSource> getDataSourcesFromServer() {
        DataSourceCollection dsc;
        ResponseHandler<DataSourceCollection<JDBCDataSource>> plIniHandler = new ResponseHandler<DataSourceCollection<JDBCDataSource>>(){

            public DataSourceCollection<JDBCDataSource> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                PlDotIni plIni;
                if (response.getStatusLine().getStatusCode() == 401) {
                    throw new AccessDeniedException("Access Denied");
                }
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new IOException("Server error while reading data sources: " + response.getStatusLine());
                }
                try {
                    plIni = new PlDotIni(ClientSideSessionUtils.getServerURI((SPServerInfo)ArchitectClientSideSession.this.projectLocation.getServiceInfo(), (String)"/rest/jdbc/"), ClientSideSessionUtils.getServerURI((SPServerInfo)ArchitectClientSideSession.this.projectLocation.getServiceInfo(), (String)ArchitectClientSideSession.MONDRIAN_SCHEMA_REL_PATH)){

                        public List<UserDefinedSQLType> getSQLTypes() {
                            ArrayList<UserDefinedSQLType> types = new ArrayList<UserDefinedSQLType>();
                            types.addAll(ArchitectClientSideSession.this.getSQLTypes());
                            types.addAll(ArchitectClientSideSession.this.getDomains());
                            return types;
                        }

                        public UserDefinedSQLType getNewSQLType(String name, int jdbcCode) {
                            UserDefinedSQLType newType = new UserDefinedSQLType();
                            newType.setName(name);
                            newType.setType(Integer.valueOf(jdbcCode));
                            ArchitectSwingProject systemWorkspace = ArchitectClientSideSession.this.getSystemWorkspace();
                            systemWorkspace.addChild((SPObject)newType, systemWorkspace.getChildren(UserDefinedSQLType.class).size());
                            return newType;
                        }

                        public SPDataSource getDataSource(String name) {
                            SPDataSource ds = super.getDataSource(name);
                            if (ds == null) {
                                this.mergeNewDataSources();
                                return super.getDataSource(name);
                            }
                            return ds;
                        }

                        public <C extends SPDataSource> C getDataSource(String name, Class<C> classType) {
                            SPDataSource ds = super.getDataSource(name, classType);
                            if (ds == null) {
                                this.mergeNewDataSources();
                                return (C)super.getDataSource(name, classType);
                            }
                            return (C)ds;
                        }

                        private void mergeNewDataSources() {
                            DataSourceCollection dsc = ArchitectClientSideSession.this.getDataSourcesFromServer();
                            for (JDBCDataSource merge : dsc.getConnections()) {
                                this.mergeDataSource((SPDataSource)merge);
                            }
                        }
                    };
                    plIni.read(response.getEntity().getContent());
                    logger.debug((Object)("Data source collection has URI " + plIni.getServerBaseURI()));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                return new SpecificDataSourceCollection((DataSourceCollection)plIni, JDBCDataSource.class);
            }
        };
        try {
            dsc = (DataSourceCollection)ClientSideSessionUtils.executeServerRequest((HttpClient)this.outboundHttpClient, (SPServerInfo)this.projectLocation.getServiceInfo(), (String)"/rest/data-sources/", (ResponseHandler)plIniHandler);
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return dsc;
    }

    public void startUpdaterThread() {
        final SPPersisterListener listener = new SPPersisterListener((SPPersister)this.jsonPersister, (SPSessionPersister)this.sessionPersister, (SessionPersisterSuperConverter)new ArchitectPersisterSuperConverter(this.dataSourceCollection, (SPObject)this.getWorkspace()));
        SQLPowerUtils.listenToHierarchy((SPObject)this.getWorkspace(), (SPListener)listener);
        this.updater.setListener(listener);
        this.updater.setConverter(new SessionPersisterSuperConverter(this.dataSourceCollection, (SPObject)this.getWorkspace()));
        this.updater.start();
        this.addSessionLifecycleListener(new SessionLifecycleListener<ArchitectSession>(){

            public void sessionClosing(SessionLifecycleEvent<ArchitectSession> e) {
                SQLPowerUtils.unlistenToHierarchy((SPObject)ArchitectClientSideSession.this.getWorkspace(), (SPListener)listener);
            }

            public void sessionOpening(SessionLifecycleEvent<ArchitectSession> e) {
            }
        });
    }

    public User getUser() {
        String username = this.getProjectLocation().getServiceInfo().getUsername();
        User currentUser = null;
        for (User user : this.getSystemWorkspace().getChildren(User.class)) {
            if (!user.getUsername().equals(username)) continue;
            currentUser = user;
        }
        return currentUser;
    }

    public void persistProjectToServer() throws SPPersistenceException {
        SPPersisterListener tempListener = new SPPersisterListener((SPPersister)this.jsonPersister, (SessionPersisterSuperConverter)new ArchitectPersisterSuperConverter(this.dataSourceCollection, (SPObject)this.getWorkspace()));
        tempListener.persistObject((SPObject)this.getWorkspace(), 0);
    }

    public ArchitectSwingProject getSystemWorkspace() {
        return ArchitectClientSideSession.getSecuritySessions().get(this.getProjectLocation().getServiceInfo().getServerAddress()).getWorkspace();
    }

    public ArchitectClientSideSession getSystemSession() {
        return ArchitectClientSideSession.getSecuritySessions().get(this.getProjectLocation().getServiceInfo().getServerAddress());
    }

    @Override
    public void runInForeground(Runnable runner) {
        if (this.getContext() instanceof ArchitectSwingSessionContext) {
            SwingUtilities.invokeLater(runner);
        } else if (this.useThreadPool) {
            this.foregroundThreadExecutor.execute(runner);
        } else {
            super.runInForeground(runner);
        }
    }

    @Override
    public boolean isForegroundThread() {
        if (this.useThreadPool) {
            return this.foregroundExecutorThread.contains(Thread.currentThread());
        }
        return super.isForegroundThread();
    }

    public static CookieStore getCookieStore() {
        return cookieStore;
    }

    public ProjectLocation getProjectLocation() {
        return this.projectLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionInformation> getTransactionList(long fromVersion, long toVersion) throws IOException, URISyntaxException, JSONException, ParseException {
        SPServerInfo serviceInfo = this.projectLocation.getServiceInfo();
        HttpClient httpClient = ClientSideSessionUtils.createHttpClient((SPServerInfo)serviceInfo, (CookieStore)cookieStore);
        try {
            logger.info((Object)("Getting transactions between " + fromVersion + " and " + toVersion));
            JSONMessage message = (JSONMessage)ClientSideSessionUtils.executeServerRequest((HttpClient)httpClient, (SPServerInfo)this.projectLocation.getServiceInfo(), (String)("/rest/project/" + this.projectLocation.getUUID() + "/revision_list"), (String)("versions=" + fromVersion + ":" + toVersion), (ResponseHandler)new JSONResponseHandler());
            List list = ClientSideSessionUtils.decodeJSONRevisionList((String)message.getBody());
            return list;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static ProjectLocation uploadProject(SPServerInfo serviceInfo, String name, File project, UserPrompterFactory session) throws URISyntaxException, ClientProtocolException, IOException, JSONException {
        return ClientSideSessionUtils.uploadProject((SPServerInfo)serviceInfo, (String)name, (File)project, (UserPrompterFactory)session, (CookieStore)cookieStore);
    }

    public int revertServerWorkspace(int revisionNo) throws IOException, URISyntaxException, JSONException {
        return ArchitectClientSideSession.revertServerWorkspace(this.projectLocation, revisionNo);
    }

    public static int revertServerWorkspace(ProjectLocation projectLocation, int revisionNo) throws IOException, URISyntaxException, JSONException {
        return ClientSideSessionUtils.revertServerWorkspace((ProjectLocation)projectLocation, (int)revisionNo, (CookieStore)cookieStore);
    }

    public void updateUserPassword(User user, String oldPassword, String newPassword, UserPrompterFactory upf) {
        MessageDigest digester;
        SPServerInfo serviceInfo = this.getProjectLocation().getServiceInfo();
        HttpClient client = ClientSideSessionUtils.createHttpClient((SPServerInfo)serviceInfo, (CookieStore)cookieStore);
        try {
            digester = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        try {
            JSONObject begin = new JSONObject();
            begin.put("uuid", JSONObject.NULL);
            begin.put("method", (Object)"begin");
            JSONObject persist = new JSONObject();
            persist.put("uuid", (Object)user.getUUID());
            persist.put("propertyName", (Object)"password");
            persist.put("type", (Object)Datatype.STRING.toString());
            if (oldPassword == null) {
                persist.put("method", (Object)"persistProperty");
            } else {
                persist.put("method", (Object)"changeProperty");
                persist.put("oldValue", (Object)new String(Hex.encodeHex((byte[])digester.digest(oldPassword.getBytes()))));
            }
            persist.put("newValue", (Object)new String(Hex.encodeHex((byte[])digester.digest(newPassword.getBytes()))));
            JSONObject commit = new JSONObject();
            commit.put("uuid", JSONObject.NULL);
            commit.put("method", (Object)"commit");
            JSONArray transaction = new JSONArray();
            transaction.put((Object)begin);
            transaction.put((Object)persist);
            transaction.put((Object)commit);
            URI serverURI = new URI("http", null, serviceInfo.getServerAddress(), serviceInfo.getPort(), serviceInfo.getPath() + "/" + "rest" + "/project/system", "currentRevision=" + this.getCurrentRevisionNumber(), null);
            HttpPost postRequest = new HttpPost(serverURI);
            postRequest.setEntity((HttpEntity)new StringEntity(transaction.toString()));
            postRequest.setHeader("Content-Type", "application/json");
            HttpPost request = postRequest;
            JSONMessage result = (JSONMessage)client.execute((HttpUriRequest)request, (ResponseHandler)new JSONResponseHandler());
            if (result.getStatusCode() != 200) {
                logger.warn((Object)"Failed password change");
                if (result.getStatusCode() == 412) {
                    upf.createUserPrompter("The password you have entered is incorrect.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, (Object)"OK", new String[]{"OK"}).promptUser(new Object[]{""});
                } else {
                    upf.createUserPrompter("Could not change the password due to the following: " + result.getBody() + " See logs for more details.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, (Object)"OK", new String[]{"OK"}).promptUser(new Object[]{""});
                }
            } else {
                upf.createUserPrompter("Password successfully changed. Please log into open projects with your new password.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, (Object)"OK", new String[]{"OK"}).promptUser(new Object[]{""});
            }
        }
        catch (AccessDeniedException ex) {
            logger.warn((Object)"Failed password change", (Throwable)ex);
            upf.createUserPrompter("The password you have entered is incorrect.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, (Object)"OK", new String[]{"OK"}).promptUser(new Object[]{""});
        }
        catch (Exception ex) {
            logger.warn((Object)"Failed password change", (Throwable)ex);
            upf.createUserPrompter("Could not change the password due to the following: " + ex.getMessage() + " See logs for more details.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, (Object)"OK", new String[]{"OK"}).promptUser(new Object[]{""});
        }
    }

    public void persistRevisionFromServer(int revisionNo, SPJSONMessageDecoder targetDecoder) throws IOException, URISyntaxException, SPPersistenceException, IllegalArgumentException {
        ArchitectClientSideSession.persistRevisionFromServer(this.projectLocation, revisionNo, targetDecoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DiffChunk<DiffInfo>> getComparisonDiffChunks(int oldRevisionNo, int newRevisionNo) throws IOException, URISyntaxException, JSONException, SPPersistenceException {
        SPServerInfo serviceInfo = this.projectLocation.getServiceInfo();
        HttpClient httpClient = ClientSideSessionUtils.createHttpClient((SPServerInfo)serviceInfo, (CookieStore)cookieStore);
        try {
            JSONMessage response = (JSONMessage)ClientSideSessionUtils.executeServerRequest((HttpClient)httpClient, (SPServerInfo)this.projectLocation.getServiceInfo(), (String)("/rest/project/" + this.projectLocation.getUUID() + "/compare"), (String)("versions=" + oldRevisionNo + ":" + newRevisionNo), (ResponseHandler)new JSONResponseHandler());
            List list = SimpleDiffChunkJSONConverter.decode((String)response.getBody());
            return list;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static HttpClient createHttpClient(SPServerInfo serviceInfo) {
        return ClientSideSessionUtils.createHttpClient((SPServerInfo)serviceInfo, (CookieStore)cookieStore);
    }

    public static void persistRevisionFromServer(ProjectLocation projectLocation, int revisionNo, SPJSONMessageDecoder decoder) throws IOException, URISyntaxException, SPPersistenceException, IllegalArgumentException {
        ClientSideSessionUtils.persistRevisionFromServer((ProjectLocation)projectLocation, (int)revisionNo, (SPJSONMessageDecoder)decoder, (CookieStore)cookieStore);
    }

    public static ProjectLocation createNewServerSession(SPServerInfo serviceInfo, String name, ArchitectSession session) throws URISyntaxException, ClientProtocolException, IOException, JSONException {
        return ClientSideSessionUtils.createNewServerSession((SPServerInfo)serviceInfo, (String)name, (CookieStore)cookieStore, (UserPrompterFactory)new DefaultUserPrompterFactory());
    }

    public static List<ProjectLocation> getWorkspaceNames(SPServerInfo serviceInfo, UserPrompterFactory upf) throws IOException, URISyntaxException, JSONException {
        return ClientSideSessionUtils.getWorkspaceNames((SPServerInfo)serviceInfo, (CookieStore)cookieStore, (UserPrompterFactory)upf);
    }

    public static void deleteServerWorkspace(ProjectLocation projectLocation, ArchitectSession session) throws URISyntaxException, ClientProtocolException, IOException {
        ClientSideSessionUtils.deleteServerWorkspace((ProjectLocation)projectLocation, (CookieStore)cookieStore, (UserPrompterFactory)new DefaultUserPrompterFactory());
    }

    public ArchitectNetworkConflictResolver getUpdater() {
        return this.updater;
    }

    public void putPref(String prefName, double pref) {
        this.prefs.putDouble(this.projectLocation.getUUID() + "." + prefName, pref);
    }

    public void putPref(String prefName, String pref) {
        this.prefs.put(this.projectLocation.getUUID() + "." + prefName, pref);
    }

    public double getPrefDouble(String prefName) {
        return this.getPrefDouble(prefName, 0.0);
    }

    public double getPrefDouble(String prefName, double def) {
        return this.prefs.getDouble(this.projectLocation.getUUID() + "." + prefName, def);
    }

    public String getPref(String prefName) {
        return this.getPref(prefName, null);
    }

    public String getPref(String prefName, String def) {
        return this.prefs.get(this.projectLocation.getUUID() + "." + prefName, def);
    }

    public int getCurrentRevisionNumber() {
        return this.updater.getRevision();
    }

    @Override
    public List<UserDefinedSQLType> getSQLTypes() {
        SnapshotCollection collection = this.getWorkspace().getSnapshotCollection();
        ArrayList typeSnapshots = new ArrayList(collection.getChildren(UserDefinedSQLTypeSnapshot.class));
        ArrayList<UserDefinedSQLType> systemTypes = new ArrayList<UserDefinedSQLType>(this.getSystemWorkspace().getChildren(UserDefinedSQLType.class));
        for (int i = typeSnapshots.size() - 1; i >= 0; --i) {
            UserDefinedSQLTypeSnapshot snapshot = (UserDefinedSQLTypeSnapshot)typeSnapshots.get(i);
            if (!snapshot.isDomainSnapshot()) continue;
            typeSnapshots.remove(i);
        }
        if (typeSnapshots.size() == 0) {
            return Collections.unmodifiableList(systemTypes);
        }
        Collections.sort(typeSnapshots, new Comparator<UserDefinedSQLTypeSnapshot>(){

            @Override
            public int compare(UserDefinedSQLTypeSnapshot o1, UserDefinedSQLTypeSnapshot o2) {
                return o1.getOriginalUUID().compareTo(o2.getOriginalUUID());
            }
        });
        Collections.sort(systemTypes, new SPObjectUUIDComparator());
        Iterator snapshotIterator = typeSnapshots.iterator();
        UserDefinedSQLTypeSnapshot currentSnapshot = (UserDefinedSQLTypeSnapshot)snapshotIterator.next();
        for (int i = 0; i < systemTypes.size(); ++i) {
            UserDefinedSQLType type = (UserDefinedSQLType)systemTypes.get(i);
            int compareTo = currentSnapshot.getOriginalUUID().compareTo(type.getUUID());
            if (compareTo > 0) continue;
            if (compareTo == 0) {
                systemTypes.set(i, currentSnapshot.getSPObject());
            } else {
                systemTypes.add(i, currentSnapshot.getSPObject());
            }
            if (!snapshotIterator.hasNext() || i == systemTypes.size() - 1) break;
            currentSnapshot = (UserDefinedSQLTypeSnapshot)snapshotIterator.next();
        }
        while (snapshotIterator.hasNext()) {
            currentSnapshot = (UserDefinedSQLTypeSnapshot)snapshotIterator.next();
            systemTypes.add(currentSnapshot.getSPObject());
        }
        return Collections.unmodifiableList(systemTypes);
    }

    @Override
    public List<UserDefinedSQLType> getDomains() {
        SnapshotCollection collection = this.getWorkspace().getSnapshotCollection();
        ArrayList typeSnapshots = new ArrayList(collection.getChildren(UserDefinedSQLTypeSnapshot.class));
        ArrayList systemCategories = new ArrayList(this.getSystemWorkspace().getChildren(DomainCategory.class));
        ArrayList<UserDefinedSQLTypeSnapshot> domainSnapshots = new ArrayList<UserDefinedSQLTypeSnapshot>();
        for (UserDefinedSQLTypeSnapshot udtSnapshot : typeSnapshots) {
            if (!udtSnapshot.isDomainSnapshot()) continue;
            domainSnapshots.add(udtSnapshot);
        }
        ArrayList<UserDefinedSQLType> systemDomains = new ArrayList<UserDefinedSQLType>();
        for (DomainCategory category : systemCategories) {
            systemDomains.addAll(category.getChildren(UserDefinedSQLType.class));
        }
        if (domainSnapshots.size() == 0) {
            return Collections.unmodifiableList(systemDomains);
        }
        Collections.sort(domainSnapshots, new Comparator<UserDefinedSQLTypeSnapshot>(){

            @Override
            public int compare(UserDefinedSQLTypeSnapshot o1, UserDefinedSQLTypeSnapshot o2) {
                return o1.getOriginalUUID().compareTo(o2.getOriginalUUID());
            }
        });
        Collections.sort(systemDomains, new SPObjectUUIDComparator());
        Iterator snapshotIterator = domainSnapshots.iterator();
        UserDefinedSQLTypeSnapshot currentSnapshot = (UserDefinedSQLTypeSnapshot)snapshotIterator.next();
        for (int i = 0; i < systemDomains.size(); ++i) {
            UserDefinedSQLType type = (UserDefinedSQLType)systemDomains.get(i);
            int compareTo = currentSnapshot.getOriginalUUID().compareTo(type.getUUID());
            if (compareTo > 0) continue;
            if (compareTo == 0) {
                systemDomains.set(i, currentSnapshot.getSPObject());
            } else {
                systemDomains.add(i, currentSnapshot.getSPObject());
            }
            if (!snapshotIterator.hasNext() || i == systemDomains.size() - 1) break;
            currentSnapshot = (UserDefinedSQLTypeSnapshot)snapshotIterator.next();
        }
        while (snapshotIterator.hasNext()) {
            currentSnapshot = (UserDefinedSQLTypeSnapshot)snapshotIterator.next();
            systemDomains.add(currentSnapshot.getSPObject());
        }
        return Collections.unmodifiableList(systemDomains);
    }

    @Override
    public ArchitectSwingProject getWorkspace() {
        return (ArchitectSwingProject)super.getWorkspace();
    }

    public UserDefinedSQLType findSystemTypeFromSnapshot(@Nonnull SPObjectSnapshot<?> snapshot) {
        for (UserDefinedSQLType systemType : this.getSystemWorkspace().getSqlTypes()) {
            if (!systemType.getUUID().equals(snapshot.getOriginalUUID())) continue;
            return systemType;
        }
        for (DomainCategory category : this.getSystemWorkspace().getDomainCategories()) {
            for (UserDefinedSQLType systemType : category.getChildren(UserDefinedSQLType.class)) {
                if (!systemType.getUUID().equals(snapshot.getOriginalUUID())) continue;
                return systemType;
            }
        }
        return null;
    }

    @Override
    public Runnable createUpdateSnapshotRunnable(final SPObjectSnapshot<?> snapshot) {
        return new Runnable(){

            @Override
            public void run() {
                if (snapshot.getSPObject() instanceof DomainCategory) {
                    for (DomainCategory category : ArchitectClientSideSession.this.getSystemWorkspace().getDomainCategories()) {
                        if (!category.getUUID().equals(snapshot.getOriginalUUID())) continue;
                        ((DomainCategory)snapshot.getSPObject()).updateToMatch(category);
                        snapshot.setObsolete(false);
                        return;
                    }
                }
                if (!(snapshot.getSPObject() instanceof UserDefinedSQLType)) {
                    return;
                }
                UserDefinedSQLType snapshotType = (UserDefinedSQLType)snapshot.getSPObject();
                UserDefinedSQLType systemType = ArchitectClientSideSession.this.findSystemTypeFromSnapshot(snapshot);
                if (systemType == null) {
                    return;
                }
                snapshotType.updateToMatch((SQLObject)systemType);
                snapshot.setObsolete(false);
            }
        };
    }
}

