/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.normaliser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.normaliser.Messages;
import org.pentaho.di.trans.steps.normaliser.Normaliser;
import org.pentaho.di.trans.steps.normaliser.NormaliserData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormaliserMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String typeField;
    private String[] fieldName;
    private String[] fieldValue;
    private String[] fieldNorm;

    public String getTypeField() {
        return this.typeField;
    }

    public void setTypeField(String typeField) {
        this.typeField = typeField;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String[] fieldValue) {
        this.fieldValue = fieldValue;
    }

    public String[] getFieldNorm() {
        return this.fieldNorm;
    }

    public void setFieldNorm(String[] fieldNorm) {
        this.fieldNorm = fieldNorm;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldValue = new String[nrfields];
        this.fieldNorm = new String[nrfields];
    }

    @Override
    public Object clone() {
        NormaliserMeta retval = (NormaliserMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldValue[i] = this.fieldValue[i];
            retval.fieldNorm[i] = this.fieldNorm[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.typeField = XMLHandler.getTagValue((Node)stepnode, (String)"typefield");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"value");
                this.fieldNorm[i] = XMLHandler.getTagValue((Node)fnode, (String)"norm");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("NormaliserMeta.Exception.UnableToLoadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.typeField = "typefield";
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldValue[i] = "value" + i;
            this.fieldNorm[i] = "value" + i;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        int i;
        ArrayList<String> norm_occ = new ArrayList<String>();
        ArrayList<String> field_occ = new ArrayList<String>();
        int maxlen = 0;
        for (int i2 = 0; i2 < this.fieldNorm.length; ++i2) {
            if (!norm_occ.contains(this.fieldNorm[i2])) {
                norm_occ.add(this.fieldNorm[i2]);
                field_occ.add(this.fieldName[i2]);
            }
            if (this.fieldValue[i2].length() <= maxlen) continue;
            maxlen = this.fieldValue[i2].length();
        }
        ValueMeta typefield_value = new ValueMeta(this.typeField, 2);
        typefield_value.setOrigin(name);
        typefield_value.setLength(maxlen);
        row.addValueMeta((ValueMetaInterface)typefield_value);
        for (i = 0; i < norm_occ.size(); ++i) {
            String normname = (String)norm_occ.get(i);
            String fieldname = (String)field_occ.get(i);
            ValueMetaInterface v = row.searchValueMeta(fieldname).clone();
            v.setName(normname);
            v.setOrigin(name);
            row.addValueMeta(v);
        }
        for (i = 0; i < this.fieldName.length; ++i) {
            int idx = row.indexOfValue(this.fieldName[i]);
            if (idx < 0) continue;
            row.removeValueMeta(idx);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("   " + XMLHandler.addTagValue((String)"typefield", (String)this.typeField));
        retval.append("    <fields>");
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>");
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"value", (String)this.fieldValue[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"norm", (String)this.fieldNorm[i]));
            retval.append("        </field>");
        }
        retval.append("      </fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.typeField = rep.getStepAttributeString(id_step, "typefield");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldValue[i] = rep.getStepAttributeString(id_step, i, "field_value");
                this.fieldNorm[i] = rep.getStepAttributeString(id_step, i, "field_norm");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("NormaliserMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "typefield", this.typeField);
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_value", this.fieldValue[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_norm", this.fieldNorm[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("NormaliserMeta.Exception.UnableToSaveStepInfoToRepository") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String error_message = "";
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, Messages.getString("NormaliserMeta.CheckResult.StepReceivingFieldsOK", prev.size() + ""), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            boolean first = true;
            error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                String lufield = this.fieldName[i];
                ValueMetaInterface v = prev.searchValueMeta(lufield);
                if (v != null) continue;
                if (first) {
                    first = false;
                    error_message = error_message + Messages.getString("NormaliserMeta.CheckResult.FieldsNotFound") + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + lufield + Const.CR;
            }
            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("NormaliserMeta.CheckResult.AllFieldsFound"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = Messages.getString("NormaliserMeta.CheckResult.CouldNotReadFieldsFromPreviousStep") + Const.CR;
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("NormaliserMeta.CheckResult.StepReceivingInfoOK"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("NormaliserMeta.CheckResult.NoInputReceivedError"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Normaliser(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new NormaliserData();
    }
}

