/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.io.Closeable;
import net.sf.saxon.expr.AdjacentTextNodeMerger;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.util.Orphan;

public class AdjacentTextNodeMergingIterator
implements LookaheadIterator,
Closeable {
    private final SequenceIterator base;
    private Item _next;

    public AdjacentTextNodeMergingIterator(SequenceIterator base) throws XPathException {
        try {
            this.base = base;
            this._next = base.next();
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }

    @Override
    public boolean hasNext() {
        return this._next != null;
    }

    @Override
    public Item next() {
        Item current = this._next;
        if (current == null) {
            return null;
        }
        this._next = this.base.next();
        if (AdjacentTextNodeMerger.isTextNode(current)) {
            UnicodeBuilder ub = new UnicodeBuilder();
            ub.accept(current.getUnicodeStringValue());
            while (AdjacentTextNodeMerger.isTextNode(this._next)) {
                ub.accept(this._next.getUnicodeStringValue());
                this._next = this.base.next();
            }
            if (ub.isEmpty()) {
                return this.next();
            }
            Orphan o = new Orphan(((NodeInfo)current).getConfiguration());
            o.setNodeKind((short)3);
            o.setStringValue(ub.toUnicodeString());
            current = o;
            return current;
        }
        return current;
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public void discharge() {
        this.base.discharge();
    }
}

