/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.HashingClassLoaderFactory;
import org.gradle.internal.classloader.ImplementationHashAware;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;

public class DefaultHashingClassLoaderFactory
extends DefaultClassLoaderFactory
implements HashingClassLoaderFactory {
    private final ClasspathHasher classpathHasher;
    private final Map<ClassLoader, HashCode> hashCodes = Collections.synchronizedMap(new WeakHashMap());

    public DefaultHashingClassLoaderFactory(ClasspathHasher classpathHasher) {
        this.classpathHasher = classpathHasher;
    }

    @Override
    protected ClassLoader doCreateClassLoader(String name, ClassLoader parent, ClassPath classPath) {
        ClassLoader classLoader = super.doCreateClassLoader(name, parent, classPath);
        this.hashCodes.put(classLoader, this.calculateClassLoaderHash(classPath));
        return classLoader;
    }

    @Override
    protected ClassLoader doCreateFilteringClassLoader(ClassLoader parent, FilteringClassLoader.Spec spec) {
        ClassLoader classLoader = super.doCreateFilteringClassLoader(parent, spec);
        this.hashCodes.put(classLoader, DefaultHashingClassLoaderFactory.calculateFilterSpecHash(spec));
        return classLoader;
    }

    public ClassLoader createChildClassLoader(String name, ClassLoader parent, ClassPath classPath, HashCode implementationHash) {
        HashCode hashCode = implementationHash != null ? implementationHash : this.calculateClassLoaderHash(classPath);
        ClassLoader classLoader = super.doCreateClassLoader(name, parent, classPath);
        this.hashCodes.put(classLoader, hashCode);
        return classLoader;
    }

    public HashCode getClassLoaderClasspathHash(ClassLoader classLoader) {
        if (classLoader instanceof ImplementationHashAware) {
            ImplementationHashAware loader = (ImplementationHashAware)classLoader;
            return loader.getImplementationHash();
        }
        return this.hashCodes.get(classLoader);
    }

    private HashCode calculateClassLoaderHash(ClassPath classPath) {
        return this.classpathHasher.hash(classPath);
    }

    private static HashCode calculateFilterSpecHash(FilteringClassLoader.Spec spec) {
        Hasher hasher = Hashing.newHasher();
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getClassNames());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getPackageNames());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getPackagePrefixes());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getResourcePrefixes());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getResourceNames());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getDisallowedClassNames());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getDisallowedPackagePrefixes());
        return hasher.hash();
    }

    private static void addToHash(Hasher hasher, Set<String> items) {
        int count = items.size();
        hasher.putInt(count);
        if (count == 0) {
            return;
        }
        Object[] sortedItems = items.toArray(new String[count]);
        Arrays.sort(sortedItems);
        for (Object item : sortedItems) {
            hasher.putString((CharSequence)item);
        }
    }
}

