/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.xml.parser;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cybergarage.xml.Node;
import org.cybergarage.xml.Parser;
import org.cybergarage.xml.ParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JaxpParser
extends Parser {
    public Node parse(Node parentNode, org.w3c.dom.Node domNode, int rank) {
        org.w3c.dom.Node child;
        NamedNodeMap attrMap;
        int arrrsLen;
        short domNodeType = domNode.getNodeType();
        String domNodeName = domNode.getNodeName();
        String domNodeValue = domNode.getNodeValue();
        NamedNodeMap attrs = domNode.getAttributes();
        int n = arrrsLen = attrs != null ? attrs.getLength() : 0;
        if (domNodeType == 3) {
            parentNode.addValue(domNodeValue);
            return parentNode;
        }
        if (domNodeType != 1) {
            return parentNode;
        }
        Node node = new Node();
        node.setName(domNodeName);
        node.setValue(domNodeValue);
        if (parentNode != null) {
            parentNode.addNode(node);
        }
        if ((attrMap = domNode.getAttributes()) != null) {
            int attrLen = attrMap.getLength();
            for (int n2 = 0; n2 < attrLen; ++n2) {
                org.w3c.dom.Node attr = attrMap.item(n2);
                String attrName = attr.getNodeName();
                String attrValue = attr.getNodeValue();
                node.setAttribute(attrName, attrValue);
            }
        }
        if ((child = domNode.getFirstChild()) == null) {
            node.setValue("");
            return node;
        }
        do {
            this.parse(node, child, rank + 1);
        } while ((child = child.getNextSibling()) != null);
        return node;
    }

    public Node parse(Node parentNode, org.w3c.dom.Node domNode) {
        return this.parse(parentNode, domNode, 0);
    }

    @Override
    public Node parse(InputStream inStream) throws ParserException {
        Node root = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setExpandEntityReferences(false);
            try {
                try {
                    factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
                try {
                    factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
                try {
                    factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
                try {
                    factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                }
                catch (ParserConfigurationException parserConfigurationException) {}
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new BlankingResolver());
            InputSource inSrc = new InputSource(new NullFilterInputStream(inStream));
            Document doc = builder.parse(inSrc);
            Element docElem = doc.getDocumentElement();
            if (docElem != null) {
                root = this.parse(root, docElem);
            }
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
        return root;
    }

    private static class BlankingResolver
    implements EntityResolver {
        private static final byte[] DUMMY = new byte[0];

        private BlankingResolver() {
        }

        @Override
        public InputSource resolveEntity(String arg0, String arg1) {
            return new InputSource(new ByteArrayInputStream(DUMMY));
        }
    }

    private static class NullFilterInputStream
    extends FilterInputStream {
        public NullFilterInputStream(InputStream is) {
            super(is);
        }

        @Override
        public int read() throws IOException {
            int rv;
            while ((rv = super.read()) == 0) {
            }
            return rv;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int i;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int rv = this.read();
            if (-1 == rv) {
                return -1;
            }
            b[off] = (byte)rv;
            for (i = 1; i < len && -1 != (rv = this.read()); ++i) {
                b[off + i] = (byte)rv;
            }
            return i;
        }
    }
}

