/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMHandlerFactory;
import net.i2p.sam.SAMSecureSessionInterface;
import net.i2p.util.Log;
import net.i2p.util.PasswordManager;

public class SAMSecureSession
implements SAMSecureSessionInterface {
    private final Log log = I2PAppContext.getGlobalContext().logManager().getLog(SAMHandlerFactory.class);

    @Override
    public boolean approveOrDenySecureSession(Properties i2cpProps, Properties props) throws SAMException {
        String user = props.getProperty("USER");
        String pw = props.getProperty("PASSWORD");
        if (user == null || pw == null) {
            if (user == null) {
                this.log.logAlways(30, "SAM authentication failed");
            } else {
                this.log.logAlways(30, "SAM authentication failed, user: " + user);
            }
            throw new SAMException("USER and PASSWORD required");
        }
        String savedPW = i2cpProps.getProperty("sam.auth." + user + ".shash");
        if (savedPW == null) {
            this.log.logAlways(30, "SAM authentication failed, user: " + user);
            throw new SAMException("Authorization failed");
        }
        PasswordManager pm = new PasswordManager(I2PAppContext.getGlobalContext());
        if (!pm.checkHash(savedPW, pw)) {
            this.log.logAlways(30, "SAM authentication failed, user: " + user);
            throw new SAMException("Authorization failed");
        }
        return true;
    }
}

