/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.JavaFormatterAnnotationUtil;
import com.intellij.psi.formatter.java.JavaFormatterRecordUtil;
import com.intellij.psi.formatter.java.wrap.ReservedWrapsProvider;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaFormatterUtil {
    private static final TokenSet ASSIGNMENT_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.ASSIGNMENT_EXPRESSION, JavaElementType.LOCAL_VARIABLE, JavaElementType.FIELD});
    private static final int CALL_EXPRESSION_DEPTH = 500;

    private JavaFormatterUtil() {
    }

    public static boolean isAssignment(ASTNode node) {
        return ASSIGNMENT_ELEMENT_TYPES.contains(node.getElementType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean areSamePriorityBinaryExpressions(ASTNode node1, ASTNode node2) {
        if (node1 == null) return false;
        if (node2 == null) {
            return false;
        }
        if (!(node1 instanceof PsiPolyadicExpression)) return false;
        PsiPolyadicExpression expression1 = (PsiPolyadicExpression)node1;
        if (!(node2 instanceof PsiPolyadicExpression)) return false;
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)node2;
        if (expression1.getOperationTokenType() != expression2.getOperationTokenType()) return false;
        return true;
    }

    @NotNull
    public static WrapType getWrapType(int wrap) {
        WrapType wrapType = switch (wrap) {
            case 2 -> WrapType.ALWAYS;
            case 1 -> WrapType.NORMAL;
            case 0 -> WrapType.NONE;
            default -> WrapType.CHOP_DOWN_IF_LONG;
        };
        if (wrapType == null) {
            JavaFormatterUtil.$$$reportNull$$$0(0);
        }
        return wrapType;
    }

    static boolean isStartOfCallChunk(@NotNull CommonCodeStyleSettings settings, @NotNull ASTNode node) {
        if (settings == null) {
            JavaFormatterUtil.$$$reportNull$$$0(1);
        }
        if (node == null) {
            JavaFormatterUtil.$$$reportNull$$$0(2);
        }
        if (node.getElementType() == JavaTokenType.DOT) {
            if (settings.KEEP_LINE_BREAKS) {
                ASTNode next = node.getTreeNext();
                if (next != null && next.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST && next.getTextLength() == 0) {
                    next = next.getTreeNext();
                }
                return next == null || !(next.getPsi() instanceof PsiWhiteSpace) || !next.textContains('\n');
            }
            return true;
        }
        if (node.getElementType() == JavaTokenType.IDENTIFIER) {
            ASTNode prev;
            if (settings.KEEP_LINE_BREAKS && (prev = node.getTreePrev()) instanceof PsiWhiteSpace && prev.textContains('\n')) {
                if ((prev = prev.getTreePrev()) != null && prev.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST && prev.getTextLength() == 0) {
                    prev = prev.getTreePrev();
                }
                return prev != null && prev.getElementType() == JavaTokenType.DOT;
            }
            return false;
        }
        return false;
    }

    @Nullable
    static Wrap createDefaultWrap(ASTBlock block, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, ReservedWrapsProvider reservedWrapsProvider) {
        ASTNode node = block.getNode();
        Wrap wrap = block.getWrap();
        if (node == null) {
            return null;
        }
        IElementType nodeType = node.getElementType();
        if (nodeType == JavaElementType.EXTENDS_LIST || nodeType == JavaElementType.IMPLEMENTS_LIST || nodeType == JavaElementType.PERMITS_LIST) {
            return Wrap.createWrap((int)settings.EXTENDS_LIST_WRAP, (boolean)false);
        }
        if (node instanceof PsiPolyadicExpression) {
            Wrap actualWrap;
            Wrap wrap2 = actualWrap = wrap != null ? wrap : reservedWrapsProvider.getReservedWrap(JavaElementType.BINARY_EXPRESSION);
            if (actualWrap == null) {
                return Wrap.createWrap((int)settings.BINARY_OPERATION_WRAP, (boolean)false);
            }
            if (JavaFormatterUtil.areSamePriorityBinaryExpressions(node, node.getTreeParent())) {
                return actualWrap;
            }
            return Wrap.createChildWrap((Wrap)actualWrap, (WrapType)WrapType.byLegacyRepresentation((int)settings.BINARY_OPERATION_WRAP), (boolean)false);
        }
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION) {
            return Wrap.createWrap((int)settings.TERNARY_OPERATION_WRAP, (boolean)false);
        }
        if (nodeType == JavaElementType.ASSERT_STATEMENT) {
            return Wrap.createWrap((int)settings.ASSERT_STATEMENT_WRAP, (boolean)false);
        }
        if (nodeType == JavaElementType.FOR_STATEMENT) {
            return Wrap.createWrap((int)settings.FOR_STATEMENT_WRAP, (boolean)false);
        }
        if (nodeType == JavaElementType.THROWS_LIST) {
            return Wrap.createWrap((int)settings.THROWS_LIST_WRAP, (boolean)true);
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            if (settings.KEEP_SIMPLE_METHODS_IN_ONE_LINE && node.getPsi().getParent() instanceof PsiMethod && !node.textContains('\n')) {
                return null;
            }
            return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false);
        }
        if (JavaFormatterUtil.isAssignment(node)) {
            return Wrap.createWrap((int)settings.ASSIGNMENT_WRAP, (boolean)true);
        }
        if (JavaFormatterUtil.isTopLevelTypeInCatchSection(nodeType, node)) {
            return Wrap.createWrap((int)javaSettings.MULTI_CATCH_TYPES_WRAP, (boolean)false);
        }
        return null;
    }

    static boolean isTopLevelTypeInCatchSection(@NotNull IElementType nodeType, ASTNode node) {
        if (nodeType == null) {
            JavaFormatterUtil.$$$reportNull$$$0(3);
        }
        if (nodeType != JavaElementType.TYPE) {
            return false;
        }
        ASTNode parent = node.getTreeParent();
        if (parent == null || parent.getElementType() != JavaElementType.PARAMETER) {
            return false;
        }
        ASTNode grandParent = parent.getTreeParent();
        return grandParent != null && grandParent.getElementType() == JavaElementType.CATCH_SECTION;
    }

    @Nullable
    static Wrap arrangeChildWrap(ASTNode child, ASTNode parent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, Wrap suggestedWrap, AbstractJavaBlock reservedWrapsProvider) {
        ASTNode directParent = child.getTreeParent();
        int role = ((CompositeElement)directParent).getChildRole(child);
        if (parent instanceof PsiPolyadicExpression) {
            boolean rOperand;
            if (role == 63 && !settings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                return null;
            }
            boolean bl = rOperand = ArrayUtil.indexOf((Object[])((PsiPolyadicExpression)parent).getOperands(), (Object)child.getPsi()) > 0;
            if (settings.BINARY_OPERATION_SIGN_ON_NEXT_LINE && rOperand) {
                return null;
            }
            return suggestedWrap;
        }
        IElementType nodeType = parent.getElementType();
        IElementType childType = child.getElementType();
        if (childType == JavaElementType.EXTENDS_LIST || childType == JavaElementType.IMPLEMENTS_LIST || childType == JavaElementType.PERMITS_LIST) {
            return Wrap.createWrap((int)settings.EXTENDS_KEYWORD_WRAP, (boolean)true);
        }
        if (childType == JavaElementType.THROWS_LIST) {
            return Wrap.createWrap((int)settings.THROWS_KEYWORD_WRAP, (boolean)true);
        }
        if (nodeType == JavaElementType.EXTENDS_LIST || nodeType == JavaElementType.IMPLEMENTS_LIST || nodeType == JavaElementType.PERMITS_LIST || nodeType == JavaElementType.THROWS_LIST) {
            return role == 29 ? suggestedWrap : null;
        }
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION) {
            if (role == 87 && !settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            if (role == 114 && !settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            if (role == 112 && settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            if (role == 113 && settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            return suggestedWrap;
        }
        if (JavaFormatterUtil.isAssignment(parent) && role != 10) {
            if (role == 20) {
                return settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE ? suggestedWrap : null;
            }
            if (role == 63) {
                return settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE ? suggestedWrap : null;
            }
            if (role == 21) {
                return settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE ? null : suggestedWrap;
            }
            if (role == 62) {
                return settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE ? null : suggestedWrap;
            }
            if (role == 22) {
                return null;
            }
            return suggestedWrap;
        }
        if (nodeType == JavaElementType.REFERENCE_EXPRESSION) {
            if (role == 55) {
                return reservedWrapsProvider.getReservedWrap(JavaElementType.REFERENCE_EXPRESSION);
            }
            return suggestedWrap;
        }
        if (nodeType == JavaElementType.FOR_STATEMENT) {
            if (role == 39 || role == 32 || role == 40) {
                return suggestedWrap;
            }
            if (role == 38) {
                boolean dontWrap = (childType == JavaElementType.CODE_BLOCK || childType == JavaElementType.BLOCK_STATEMENT) && settings.BRACE_STYLE == 1;
                return Wrap.createWrap((WrapType)(dontWrap ? WrapType.NONE : WrapType.NORMAL), (boolean)true);
            }
            return null;
        }
        if (parent.getPsi() instanceof PsiModifierListOwner) {
            ASTNode last;
            ASTNode prev = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child);
            if (prev != null && prev.getElementType() == JavaElementType.MODIFIER_LIST && (last = prev.getLastChildNode()) != null && last.getElementType() == JavaElementType.ANNOTATION) {
                if (JavaFormatterAnnotationUtil.isTypeAnnotation(last) && parent.getElementType() != JavaElementType.RECORD_COMPONENT || javaSettings.DO_NOT_WRAP_AFTER_SINGLE_ANNOTATION && JavaFormatterUtil.isModifierListWithSingleAnnotation(prev, JavaElementType.FIELD) || javaSettings.DO_NOT_WRAP_AFTER_SINGLE_ANNOTATION_IN_PARAMETER && JavaFormatterUtil.isModifierListWithSingleAnnotation(prev, JavaElementType.PARAMETER) || JavaFormatterUtil.isAnnotationAfterKeyword(last)) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                }
                return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(JavaFormatterUtil.getAnnotationWrapType(parent, child, settings, javaSettings)), (boolean)true);
            }
            return null;
        }
        if (nodeType == JavaElementType.MODIFIER_LIST) {
            if (childType == JavaElementType.ANNOTATION) {
                ASTNode prev = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child);
                if (prev instanceof PsiKeyword) {
                    return null;
                }
                if (JavaFormatterUtil.isAnnoInsideModifierListWithAtLeastOneKeyword(child, parent) || JavaFormatterRecordUtil.isInRecordComponent(child) && prev == null) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                }
                if (JavaFormatterAnnotationUtil.isTypeAnnotation(child) && (prev == null || prev.getElementType() != JavaElementType.ANNOTATION || JavaFormatterAnnotationUtil.isTypeAnnotation(prev) && !JavaFormatterRecordUtil.isInRecordComponent(child))) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                }
                return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(JavaFormatterUtil.getAnnotationWrapType(parent.getTreeParent(), child, settings, javaSettings)), (boolean)true);
            }
            if (childType == JavaTokenType.END_OF_LINE_COMMENT) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
            ASTNode prev = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child);
            if (prev != null && prev.getElementType() == JavaElementType.ANNOTATION) {
                if (javaSettings.DO_NOT_WRAP_AFTER_SINGLE_ANNOTATION && JavaFormatterUtil.isModifierListWithSingleAnnotation(parent, JavaElementType.FIELD)) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                }
                Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(JavaFormatterUtil.getAnnotationWrapType(parent.getTreeParent(), child, settings, javaSettings)), (boolean)true);
                JavaFormatterUtil.putPreferredWrapInParentBlock(reservedWrapsProvider, wrap);
                return wrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.ASSERT_STATEMENT) {
            if (role == 32) {
                return suggestedWrap;
            }
            if (role == 117 && !settings.ASSERT_STATEMENT_COLON_ON_NEXT_LINE) {
                return suggestedWrap;
            }
            if (role == 87 && settings.ASSERT_STATEMENT_COLON_ON_NEXT_LINE) {
                return suggestedWrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            if (child.getPsi() instanceof PsiStatement) {
                return suggestedWrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.IF_STATEMENT) {
            if (childType == JavaElementType.IF_STATEMENT && role == 34 && settings.SPECIAL_ELSE_IF_TREATMENT) {
                return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
            }
            if (role == 33 || role == 34) {
                if (childType == JavaElementType.BLOCK_STATEMENT) {
                    return null;
                }
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        } else if (nodeType == JavaElementType.FOREACH_STATEMENT || nodeType == JavaElementType.WHILE_STATEMENT) {
            if (role == 38) {
                if (childType == JavaElementType.BLOCK_STATEMENT) {
                    return null;
                }
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        } else if (nodeType == JavaElementType.DO_WHILE_STATEMENT) {
            if (role == 38 || role == 35 && JavaFormatterUtil.isAfterNonBlockStatement(child)) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        } else if (nodeType == JavaElementType.ANNOTATION_ARRAY_INITIALIZER) {
            if (suggestedWrap != null) {
                return suggestedWrap;
            }
            if (role == 249) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        } else {
            if (nodeType == JavaElementType.SWITCH_LABELED_RULE && childType == JavaElementType.BLOCK_STATEMENT) {
                boolean dontNeedBreak = settings.BRACE_STYLE == 1;
                return Wrap.createWrap((WrapType)(dontNeedBreak ? WrapType.NONE : WrapType.NORMAL), (boolean)true);
            }
            if (nodeType == JavaElementType.SWITCH_LABELED_RULE && ElementType.JAVA_STATEMENT_BIT_SET.contains(childType)) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        }
        return suggestedWrap;
    }

    private static boolean isAnnotationAfterKeyword(@NotNull ASTNode annotation) {
        if (annotation == null) {
            JavaFormatterUtil.$$$reportNull$$$0(4);
        }
        for (ASTNode current = annotation.getTreePrev(); current != null; current = current.getTreePrev()) {
            if (!(current instanceof PsiKeyword)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAfterNonBlockStatement(@NotNull ASTNode node) {
        ASTNode prev;
        if (node == null) {
            JavaFormatterUtil.$$$reportNull$$$0(5);
        }
        if ((prev = node.getTreePrev()) instanceof PsiWhiteSpace) {
            prev = prev.getTreePrev();
        }
        return prev != null && prev.getElementType() != JavaElementType.BLOCK_STATEMENT;
    }

    private static void putPreferredWrapInParentBlock(@NotNull AbstractJavaBlock block, @NotNull Wrap preferredWrap) {
        AbstractJavaBlock parentBlock;
        if (block == null) {
            JavaFormatterUtil.$$$reportNull$$$0(6);
        }
        if (preferredWrap == null) {
            JavaFormatterUtil.$$$reportNull$$$0(7);
        }
        if ((parentBlock = block.getParentBlock()) != null) {
            parentBlock.setReservedWrap(preferredWrap, JavaElementType.MODIFIER_LIST);
        }
    }

    private static boolean isModifierListWithSingleAnnotation(@NotNull ASTNode elem, IElementType parentElementType) {
        ASTNode parent;
        if (elem == null) {
            JavaFormatterUtil.$$$reportNull$$$0(8);
        }
        if ((parent = elem.getTreeParent()) != null && parent.getElementType() == parentElementType) {
            return JavaFormatterUtil.isModifierListWithSingleAnnotation(elem);
        }
        return false;
    }

    private static boolean isModifierListWithSingleAnnotation(@NotNull ASTNode elem) {
        if (elem == null) {
            JavaFormatterUtil.$$$reportNull$$$0(9);
        }
        return elem.getPsi() instanceof PsiModifierList && ((PsiModifierList)elem.getPsi()).getAnnotations().length == 1;
    }

    private static int getAnnotationWrapType(ASTNode parent, ASTNode child, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        IElementType nodeType = parent.getElementType();
        if (nodeType == JavaElementType.METHOD) {
            return settings.METHOD_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.CLASS) {
            if (child.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
                return 0;
            }
            for (ASTNode node = child.getTreeNext(); node != null; node = node.getTreeNext()) {
                if (node.getElementType() == TokenType.WHITE_SPACE || node instanceof PsiTypeElement || !(node instanceof PsiErrorElement)) continue;
                return settings.FIELD_ANNOTATION_WRAP;
            }
            return settings.CLASS_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.FIELD) {
            return settings.FIELD_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.RECORD_COMPONENT) {
            return JavaFormatterUtil.isAnnotationOnNewLineInRecordComponent(javaSettings) ? 2 : 0;
        }
        if (nodeType == JavaElementType.PARAMETER || nodeType == JavaElementType.RECEIVER_PARAMETER || nodeType == JavaElementType.RESOURCE_VARIABLE) {
            return settings.PARAMETER_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.LOCAL_VARIABLE) {
            return settings.VARIABLE_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.MODULE) {
            return settings.CLASS_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.ENUM_CONSTANT) {
            return javaSettings.ENUM_FIELD_ANNOTATION_WRAP;
        }
        return 0;
    }

    private static boolean isAnnotationOnNewLineInRecordComponent(JavaCodeStyleSettings javaSettings) {
        return 2 == javaSettings.RECORD_COMPONENTS_WRAP && javaSettings.ANNOTATION_NEW_LINE_IN_RECORD_COMPONENT;
    }

    private static boolean isAnnoInsideModifierListWithAtLeastOneKeyword(@NotNull ASTNode current, @NotNull ASTNode parent) {
        if (current == null) {
            JavaFormatterUtil.$$$reportNull$$$0(10);
        }
        if (parent == null) {
            JavaFormatterUtil.$$$reportNull$$$0(11);
        }
        if (current.getElementType() != JavaElementType.ANNOTATION || parent.getElementType() != JavaElementType.MODIFIER_LIST) {
            return false;
        }
        do {
            if (!((current = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)current)) instanceof PsiKeyword)) continue;
            ASTNode grandParent = parent.getTreeParent();
            return grandParent != null && grandParent.getElementType() == JavaElementType.METHOD;
        } while (current != null && current.getElementType() == JavaElementType.ANNOTATION);
        return false;
    }

    public static void collectCallExpressionNodes(@NotNull List<? super ASTNode> nodes, @NotNull ASTNode node) {
        if (nodes == null) {
            JavaFormatterUtil.$$$reportNull$$$0(12);
        }
        if (node == null) {
            JavaFormatterUtil.$$$reportNull$$$0(13);
        }
        ArrayDeque<ASTNode> stack = new ArrayDeque<ASTNode>(500);
        stack.addLast(node.getFirstChildNode());
        while (!stack.isEmpty()) {
            if (stack.size() >= 500) {
                nodes.clear();
                return;
            }
            ASTNode currentNode = (ASTNode)stack.removeLast();
            if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)currentNode)) {
                IElementType type = currentNode.getElementType();
                if (type == JavaElementType.METHOD_CALL_EXPRESSION || type == JavaElementType.REFERENCE_EXPRESSION) {
                    ASTNode firstChild = currentNode.getFirstChildNode();
                    currentNode = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)currentNode);
                    ContainerUtil.addIfNotNull(stack, (Object)currentNode);
                    ContainerUtil.addIfNotNull(stack, (Object)firstChild);
                    continue;
                }
                nodes.add((ASTNode)currentNode);
                currentNode = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)currentNode);
                ContainerUtil.addIfNotNull(stack, (Object)currentNode);
                continue;
            }
            currentNode = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)currentNode);
            ContainerUtil.addIfNotNull(stack, (Object)currentNode);
        }
    }

    @NotNull
    static List<TextRange> extractTextRangesFromLiteralText(@NotNull String text, int indent) {
        if (text == null) {
            JavaFormatterUtil.$$$reportNull$$$0(14);
        }
        ArrayList<TextRange> linesRanges = new ArrayList<TextRange>();
        boolean isLastLine = false;
        int start = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)3);
        if (start == -1) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                JavaFormatterUtil.$$$reportNull$$$0(15);
            }
            return list;
        }
        linesRanges.add(new TextRange(0, start));
        ++start;
        while (start < text.length()) {
            int end = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)start);
            if (end == -1) {
                isLastLine = true;
                end = text.length();
            }
            if (start + indent <= end) {
                int quoteStartIndex = end - 3;
                start = !isLastLine && JavaFormatterUtil.containsOnlyWhitespaces(start + indent, end, text) ? end : (isLastLine && JavaFormatterUtil.containsOnlyWhitespaces(start + indent, quoteStartIndex, text) && text.endsWith("\"\"\"") ? quoteStartIndex : (start += indent));
            } else {
                start = end;
            }
            linesRanges.add(new TextRange(start, end));
            start = end + 1;
        }
        ArrayList<TextRange> arrayList = linesRanges;
        if (arrayList == null) {
            JavaFormatterUtil.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static boolean containsOnlyWhitespaces(int start, int end, @NotNull String text) {
        if (text == null) {
            JavaFormatterUtil.$$$reportNull$$$0(17);
        }
        for (int i = start; i < end; ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isExplicitlyAbstract(@NotNull PsiMethod method) {
        PsiClass clazz;
        PsiElement psiElement;
        PsiModifierList modifierList;
        if (method == null) {
            JavaFormatterUtil.$$$reportNull$$$0(18);
        }
        return (modifierList = method.getModifierList()).hasExplicitModifier("abstract") || (psiElement = method.getParent()) instanceof PsiClass && (clazz = (PsiClass)psiElement).isInterface() && !modifierList.hasExplicitModifier("default") && !modifierList.hasExplicitModifier("static");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/JavaFormatterUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredWrap";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/JavaFormatterUtil";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTextRangesFromLiteralText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isStartOfCallChunk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelTypeInCatchSection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationAfterKeyword";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAfterNonBlockStatement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putPreferredWrapInParentBlock";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isModifierListWithSingleAnnotation";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAnnoInsideModifierListWithAtLeastOneKeyword";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectCallExpressionNodes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractTextRangesFromLiteralText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "containsOnlyWhitespaces";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isExplicitlyAbstract";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17, 18 -> new IllegalArgumentException(string);
        };
    }
}

