/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.traces;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.opentelemetry.proto.trace.v1.internal.Span;
import io.opentelemetry.sdk.trace.data.EventData;
import java.io.IOException;

final class SpanEventStatelessMarshaler
implements StatelessMarshaler<EventData> {
    static final SpanEventStatelessMarshaler INSTANCE = new SpanEventStatelessMarshaler();

    private SpanEventStatelessMarshaler() {
    }

    public void writeTo(Serializer output, EventData event, MarshalerContext context) throws IOException {
        output.serializeFixed64(Span.Event.TIME_UNIX_NANO, event.getEpochNanos());
        output.serializeStringWithContext(Span.Event.NAME, event.getName(), context);
        output.serializeRepeatedMessageWithContext(Span.Event.ATTRIBUTES, event.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, context);
        int droppedAttributesCount = event.getTotalAttributeCount() - event.getAttributes().size();
        output.serializeUInt32(Span.Event.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
    }

    public int getBinarySerializedSize(EventData event, MarshalerContext context) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)Span.Event.TIME_UNIX_NANO, (long)event.getEpochNanos());
        size += StatelessMarshalerUtil.sizeStringWithContext((ProtoFieldInfo)Span.Event.NAME, (String)event.getName(), (MarshalerContext)context);
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)Span.Event.ATTRIBUTES, (Attributes)event.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        int droppedAttributesCount = event.getTotalAttributeCount() - event.getAttributes().size();
        return size += MarshalerUtil.sizeUInt32((ProtoFieldInfo)Span.Event.DROPPED_ATTRIBUTES_COUNT, (int)droppedAttributesCount);
    }
}

