/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant.type;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.integration.ant.type.ConnectionProperties;
import liquibase.resource.ClassLoaderResourceAccessor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.LoaderUtils;

public class DatabaseType
extends DataType {
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private String driver;
    private String url;
    private String user;
    private String password;
    private ConnectionProperties connectionProperties;
    private String defaultSchemaName;
    private String defaultCatalogName;
    private String currentDateTimeFunction;
    private boolean outputDefaultSchema = true;
    private boolean outputDefaultCatalog = true;
    private String liquibaseSchemaName;
    private String liquibaseCatalogName;
    private String databaseClass;
    private String databaseChangeLogTableName;
    private String databaseChangeLogLockTableName;
    private String liquibaseTablespaceName;

    public DatabaseType(Project project) {
        this.setProject(project);
    }

    public Database createDatabase() {
        ClassLoader contextClassLoader = LoaderUtils.getContextClassLoader();
        return this.createDatabase(contextClassLoader);
    }

    public Database createDatabase(ClassLoader classLoader) {
        this.logParameters();
        this.validateParameters();
        try {
            String liquibaseTablespaceName;
            String databaseChangeLogLockTableName;
            String databaseChangeLogTableName;
            String liquibaseCatalogName;
            String currentDateTimeFunction;
            String catalogName;
            DatabaseConnection jdbcConnection;
            DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
            if (this.databaseClass != null) {
                Database databaseInstance = (Database)ClasspathUtils.newInstance((String)this.databaseClass, (ClassLoader)classLoader, Database.class);
                databaseFactory.register(databaseInstance);
            }
            if (this.getUrl().startsWith("offline:")) {
                jdbcConnection = new OfflineConnection(this.getUrl(), new ClassLoaderResourceAccessor(classLoader));
            } else {
                Connection connection;
                ConnectionProperties connectionProperties;
                String password;
                Driver driver = (Driver)ClasspathUtils.newInstance((String)this.getDriver(), (ClassLoader)classLoader, Driver.class);
                if (driver == null) {
                    throw new BuildException("Unable to create Liquibase Database instance. Could not instantiate the JDBC driver.");
                }
                Properties connectionProps = new Properties();
                String user = this.getUser();
                if (user != null && !user.isEmpty()) {
                    connectionProps.setProperty(USER, user);
                }
                if ((password = this.getPassword()) != null && !password.isEmpty()) {
                    connectionProps.setProperty(PASSWORD, password);
                }
                if ((connectionProperties = this.getConnectionProperties()) != null) {
                    connectionProps.putAll((Map<?, ?>)connectionProperties.buildProperties());
                }
                if ((connection = driver.connect(this.getUrl(), connectionProps)) == null) {
                    throw new BuildException("Unable to create Liquibase Database instance. Could not connect to the database.");
                }
                jdbcConnection = new JdbcConnection(connection);
            }
            Database database = databaseFactory.findCorrectDatabaseImplementation(jdbcConnection);
            String schemaName = this.getDefaultSchemaName();
            if (schemaName != null) {
                database.setDefaultSchemaName(schemaName);
            }
            if ((catalogName = this.getDefaultCatalogName()) != null) {
                database.setDefaultCatalogName(catalogName);
            }
            if ((currentDateTimeFunction = this.getCurrentDateTimeFunction()) != null) {
                database.setCurrentDateTimeFunction(currentDateTimeFunction);
            }
            database.setOutputDefaultSchema(this.isOutputDefaultSchema());
            database.setOutputDefaultCatalog(this.isOutputDefaultCatalog());
            String liquibaseSchemaName = this.getLiquibaseSchemaName();
            if (liquibaseSchemaName != null) {
                database.setLiquibaseSchemaName(liquibaseSchemaName);
            }
            if ((liquibaseCatalogName = this.getLiquibaseCatalogName()) != null) {
                database.setLiquibaseCatalogName(liquibaseCatalogName);
            }
            if ((databaseChangeLogTableName = this.getDatabaseChangeLogTableName()) != null) {
                database.setDatabaseChangeLogTableName(databaseChangeLogTableName);
            }
            if ((databaseChangeLogLockTableName = this.getDatabaseChangeLogLockTableName()) != null) {
                database.setDatabaseChangeLogLockTableName(databaseChangeLogLockTableName);
            }
            if ((liquibaseTablespaceName = this.getLiquibaseTablespaceName()) != null) {
                database.setLiquibaseTablespaceName(liquibaseTablespaceName);
            }
            return database;
        }
        catch (SQLException e) {
            throw new BuildException("Unable to create Liquibase database instance. A JDBC error occurred. " + e.toString(), (Throwable)e);
        }
        catch (DatabaseException e) {
            throw new BuildException("Unable to create Liquibase database instance. " + e.toString(), (Throwable)e);
        }
    }

    private void validateParameters() {
        if (this.getUrl() == null) {
            throw new BuildException("JDBC URL is required.");
        }
        if (this.getDriver() == null && !this.getUrl().startsWith("offline:")) {
            throw new BuildException("JDBC driver is required.");
        }
    }

    private void logParameters() {
        this.log("Creating Liquibase Database", 4);
        this.log("JDBC driver: " + this.driver, 4);
        this.log("JDBC URL: " + this.url, 4);
        this.log("JDBC username: " + this.user, 4);
        this.log("Default catalog name: " + this.defaultCatalogName, 4);
        this.log("Default schema name: " + this.defaultSchemaName, 4);
        this.log("Liquibase catalog name: " + this.liquibaseCatalogName, 4);
        this.log("Liquibase schema name: " + this.liquibaseSchemaName, 4);
        this.log("Liquibase tablespace name: " + this.liquibaseTablespaceName, 4);
        this.log("Database changelog table name: " + this.databaseChangeLogTableName, 4);
        this.log("Database changelog lock table name: " + this.databaseChangeLogLockTableName, 4);
        this.log("Output default catalog: " + this.outputDefaultCatalog, 4);
        this.log("Output default schema: " + this.outputDefaultSchema, 4);
        this.log("Current date/time function: " + this.currentDateTimeFunction, 4);
        this.log("Database class: " + this.databaseClass, 4);
    }

    public void setRefid(Reference ref) {
        if (this.driver != null || this.url != null || this.user != null || this.password != null || this.defaultSchemaName != null || this.defaultCatalogName != null || this.currentDateTimeFunction != null || this.databaseClass != null || this.liquibaseSchemaName != null || this.liquibaseCatalogName != null || this.databaseChangeLogTableName != null || this.databaseChangeLogLockTableName != null || this.liquibaseTablespaceName != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(ref);
    }

    public String getDriver() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getDriver() : this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getUrl() : this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getUser() : this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getPassword() : this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConnectionProperties getConnectionProperties() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getConnectionProperties() : this.connectionProperties;
    }

    public void addConnectionProperties(ConnectionProperties connectionProperties) {
        if (this.connectionProperties != null) {
            throw new BuildException("Only one <connectionProperties> element is allowed.");
        }
        this.connectionProperties = connectionProperties;
    }

    public String getDefaultSchemaName() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getDefaultSchemaName() : this.defaultSchemaName;
    }

    public void setDefaultSchemaName(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    public String getDefaultCatalogName() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getDefaultCatalogName() : this.defaultCatalogName;
    }

    public void setDefaultCatalogName(String defaultCatalogName) {
        this.defaultCatalogName = defaultCatalogName;
    }

    public String getCurrentDateTimeFunction() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getCurrentDateTimeFunction() : this.currentDateTimeFunction;
    }

    public void setCurrentDateTimeFunction(String currentDateTimeFunction) {
        this.currentDateTimeFunction = currentDateTimeFunction;
    }

    public boolean isOutputDefaultSchema() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).isOutputDefaultSchema() : this.outputDefaultSchema;
    }

    public void setOutputDefaultSchema(boolean outputDefaultSchema) {
        this.outputDefaultSchema = outputDefaultSchema;
    }

    public boolean isOutputDefaultCatalog() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).isOutputDefaultCatalog() : this.outputDefaultCatalog;
    }

    public void setOutputDefaultCatalog(boolean outputDefaultCatalog) {
        this.outputDefaultCatalog = outputDefaultCatalog;
    }

    public String getDatabaseClass() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getDatabaseClass() : this.databaseClass;
    }

    public void setDatabaseClass(String databaseClass) {
        this.databaseClass = databaseClass;
    }

    public String getLiquibaseSchemaName() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getLiquibaseSchemaName() : this.liquibaseSchemaName;
    }

    public void setLiquibaseSchemaName(String liquibaseSchemaName) {
        this.liquibaseSchemaName = liquibaseSchemaName;
    }

    public String getLiquibaseCatalogName() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getLiquibaseCatalogName() : this.liquibaseCatalogName;
    }

    public void setLiquibaseCatalogName(String liquibaseCatalogName) {
        this.liquibaseCatalogName = liquibaseCatalogName;
    }

    public String getDatabaseChangeLogTableName() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getDatabaseChangeLogTableName() : this.databaseChangeLogTableName;
    }

    public void setDatabaseChangeLogTableName(String databaseChangeLogTableName) {
        this.databaseChangeLogTableName = databaseChangeLogTableName;
    }

    public String getDatabaseChangeLogLockTableName() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getDatabaseChangeLogLockTableName() : this.databaseChangeLogLockTableName;
    }

    public void setDatabaseChangeLogLockTableName(String databaseChangeLogLockTableName) {
        this.databaseChangeLogLockTableName = databaseChangeLogLockTableName;
    }

    public String getLiquibaseTablespaceName() {
        return this.isReference() ? ((DatabaseType)((Object)this.getCheckedRef())).getLiquibaseTablespaceName() : this.liquibaseTablespaceName;
    }

    public void setLiquibaseTablespaceName(String liquibaseTablespaceName) {
        this.liquibaseTablespaceName = liquibaseTablespaceName;
    }
}

