/*
 * Decompiled with CFR 0.152.
 */
package lucee.cli.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import lucee.cli.util.EnumerationWrapper;
import org.apache.felix.framework.Logger;

public class ServletContextImpl
implements ServletContext {
    private final Map<String, Object> attributes;
    private final Map<String, String> parameters;
    private final int majorVersion;
    private final int minorVersion;
    private final File root;
    private Logger logger;

    public ServletContextImpl(File root, Map<String, Object> attributes, Map<String, String> parameters, int majorVersion, int minorVersion) {
        this.root = root;
        this.attributes = attributes;
        this.parameters = parameters;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Enumeration<String> getAttributeNames() {
        return new EnumerationWrapper<String>(this.attributes);
    }

    public String getInitParameter(String key) {
        return this.parameters.get(key);
    }

    public Enumeration<String> getInitParameterNames() {
        return new EnumerationWrapper<String>(this.parameters);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getMimeType(String file) {
        throw this.notSupported("getMimeType(String file)");
    }

    public String getRealPath(String realpath) {
        return this.getRealFile(realpath).getAbsolutePath();
    }

    public URL getResource(String realpath) throws MalformedURLException {
        File file = this.getRealFile(realpath);
        return file.toURI().toURL();
    }

    public InputStream getResourceAsStream(String realpath) {
        try {
            return new FileInputStream(this.getRealFile(realpath));
        }
        catch (IOException e) {
            return null;
        }
    }

    public File getRealFile(String realpath) {
        return new File(this.root, realpath);
    }

    public File getRoot() {
        return this.root;
    }

    public Set<String> getResourcePaths(String realpath) {
        throw this.notSupported("getResourcePaths(String realpath)");
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw this.notSupported("getNamedDispatcher(String name)");
    }

    public ServletContext getContext(String key) {
        return this;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw this.notSupported("getNamedDispatcher(String name)");
    }

    public void log(String msg, Throwable t) {
        if (this.logger == null) {
            return;
        }
        if (t == null) {
            this.logger.log(3, msg);
        } else {
            this.logger.log(1, msg, t);
        }
    }

    public void log(Exception e, String msg) {
        this.log(msg, e);
    }

    public void log(String msg) {
        this.log(msg, null);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public String getServletContextName() {
        return null;
    }

    public String getServerInfo() {
        throw this.notSupported("getServlet()");
    }

    public Servlet getServlet(String arg0) throws ServletException {
        throw this.notSupported("getServlet()");
    }

    public Enumeration<String> getServletNames() {
        throw this.notSupported("getServlet()");
    }

    public Enumeration<Servlet> getServlets() {
        throw this.notSupported("getServlet()");
    }

    private RuntimeException notSupported(String method) {
        throw new RuntimeException((Throwable)new ServletException("method " + method + " not supported"));
    }

    public FilterRegistration.Dynamic addFilter(String arg0, String arg1) {
        throw this.notSupported("");
    }

    public FilterRegistration.Dynamic addFilter(String arg0, Filter arg1) {
        throw this.notSupported("");
    }

    public FilterRegistration.Dynamic addFilter(String arg0, Class<? extends Filter> arg1) {
        throw this.notSupported("");
    }

    public void addListener(String arg0) {
        throw this.notSupported("");
    }

    public <T extends EventListener> void addListener(T arg0) {
        throw this.notSupported("");
    }

    public void addListener(Class<? extends EventListener> arg0) {
        throw this.notSupported("");
    }

    public ServletRegistration.Dynamic addServlet(String arg0, String arg1) {
        throw this.notSupported("");
    }

    public ServletRegistration.Dynamic addServlet(String arg0, Servlet arg1) {
        throw this.notSupported("");
    }

    public ServletRegistration.Dynamic addServlet(String arg0, Class<? extends Servlet> arg1) {
        throw this.notSupported("addServlet");
    }

    public <T extends Filter> T createFilter(Class<T> arg0) throws ServletException {
        throw this.notSupported("createFilter");
    }

    public <T extends EventListener> T createListener(Class<T> arg0) throws ServletException {
        throw this.notSupported("createListener");
    }

    public <T extends Servlet> T createServlet(Class<T> arg0) throws ServletException {
        throw this.notSupported("createServlet");
    }

    public void declareRoles(String ... arg0) {
        throw this.notSupported("declareRoles(String ...)");
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public String getContextPath() {
        return this.root.getAbsolutePath();
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        throw this.notSupported("getDefaultSessionTrackingModes()");
    }

    public int getEffectiveMajorVersion() {
        return this.getMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.getMinorVersion();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        throw this.notSupported("getEffectiveSessionTrackingModes()");
    }

    public FilterRegistration getFilterRegistration(String arg0) {
        throw this.notSupported("getFilterRegistration(String)");
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        throw this.notSupported("getFilterRegistrations()");
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw this.notSupported("getJspConfigDescriptor()");
    }

    public ServletRegistration getServletRegistration(String arg0) {
        throw this.notSupported("getServletRegistration(String)");
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        throw this.notSupported("getServletRegistrations()");
    }

    public SessionCookieConfig getSessionCookieConfig() {
        throw this.notSupported("getSessionCookieConfig()");
    }

    public String getVirtualServerName() {
        throw this.notSupported("getVirtualServerName()");
    }

    public boolean setInitParameter(String name, String value) {
        if (!this.parameters.containsKey(name)) {
            this.parameters.put(name, value);
            return true;
        }
        return false;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> arg0) {
        throw this.notSupported("setSessionTrackingModes(Set<SessionTrackingMode>) ");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public ServletRegistration.Dynamic addJspFile(String s, String s1) {
        return null;
    }

    public int getSessionTimeout() {
        return 0;
    }

    public void setSessionTimeout(int i) {
    }

    public String getRequestCharacterEncoding() {
        return null;
    }

    public void setRequestCharacterEncoding(String s) {
    }

    public String getResponseCharacterEncoding() {
        return null;
    }

    public void setResponseCharacterEncoding(String s) {
    }
}

